/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.files;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.johnnei.javatorrent.bittorrent.encoding.SHA1;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.files.Block;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.utils.MathUtils;
import org.johnnei.javatorrent.utils.StringUtils;

public class Piece {
    private static final String ERR_BLOCK_IS_NOT_WITHIN_PIECE = "Block %d is not within the %d blocks of %s";
    protected AbstractFileSet files;
    private int index;
    private List<Block> blocks;
    private int hashFailCheck;
    private byte[] expectedHash;

    public Piece(AbstractFileSet files, byte[] hash, int index, int pieceSize, int blockSize) {
        this.index = index;
        this.files = files;
        this.expectedHash = hash;
        this.blocks = new ArrayList<Block>(MathUtils.ceilDivision(pieceSize, blockSize));
        int blockIndex = 0;
        int remainingPieceSize = pieceSize;
        while (remainingPieceSize > 0) {
            Block block = new Block(blockIndex, Math.min(blockSize, remainingPieceSize));
            remainingPieceSize -= block.getSize();
            this.blocks.add(block);
            ++blockIndex;
        }
    }

    public void onHashMismatch() {
        int tenPercent = MathUtils.ceilDivision(this.blocks.size(), 10);
        for (int i = 0; i < tenPercent; ++i) {
            this.blocks.get(this.hashFailCheck++).setStatus(BlockStatus.Needed);
            if (this.hashFailCheck < this.blocks.size()) continue;
            this.hashFailCheck = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadPiece(int offset, int length) throws IOException {
        int bytesToRead;
        byte[] pieceData = new byte[length];
        for (int readBytes = 0; readBytes < length; readBytes += bytesToRead) {
            int alreadyReadOffset = offset + readBytes;
            FileInfo outputFile = this.files.getFileForBytes(this.index, alreadyReadOffset / this.files.getBlockSize(), alreadyReadOffset % this.files.getBlockSize());
            long pieceIndexOffset = (long)this.index * this.files.getPieceSize();
            long totalOffset = pieceIndexOffset + (long)alreadyReadOffset;
            long offsetInFile = totalOffset - outputFile.getFirstByteOffset();
            bytesToRead = Math.min(length - readBytes, (int)(outputFile.getSize() - offsetInFile));
            if (offsetInFile < 0L) {
                throw new IOException("Cannot seek to position: " + offsetInFile);
            }
            Object object = outputFile.fileLock;
            synchronized (object) {
                RandomAccessFile file = outputFile.getFileAccess();
                file.seek(offsetInFile);
                file.readFully(pieceData, readBytes, bytesToRead);
                continue;
            }
        }
        return pieceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkHash() throws IOException {
        int pieceSize;
        int remainingBytes = pieceSize = this.getSize();
        int alreadyReadOffset = 0;
        while (remainingBytes > 0) {
            long fileSize;
            FileInfo file = this.files.getFileForBytes(this.index, alreadyReadOffset / this.files.getBlockSize(), alreadyReadOffset % this.files.getBlockSize());
            long pieceIndexOffset = (long)this.index * this.files.getPieceSize();
            long totalOffset = pieceIndexOffset + (long)alreadyReadOffset;
            long offsetInFile = totalOffset - file.getFirstByteOffset();
            Object object = file.fileLock;
            synchronized (object) {
                fileSize = file.getFileAccess().length();
            }
            long availableBytes = fileSize - offsetInFile;
            if (availableBytes <= 0L) {
                return false;
            }
            remainingBytes = (int)((long)remainingBytes - availableBytes);
            alreadyReadOffset = (int)((long)alreadyReadOffset + availableBytes);
        }
        byte[] pieceData = this.loadPiece(0, pieceSize);
        return Arrays.equals(this.expectedHash, SHA1.hash(pieceData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeBlock(int blockIndex, byte[] blockData) throws IOException {
        int bytesToWrite;
        Block block = this.blocks.get(blockIndex);
        for (int remainingBytesToWrite = block.getSize(); remainingBytesToWrite > 0; remainingBytesToWrite -= bytesToWrite) {
            int dataOffset = block.getSize() - remainingBytesToWrite;
            FileInfo outputFile = this.files.getFileForBytes(this.index, blockIndex, dataOffset);
            long pieceOffset = (long)this.index * this.files.getPieceSize();
            long blockOffset = (long)blockIndex * (long)this.files.getBlockSize();
            long totalOffset = pieceOffset + blockOffset + (long)dataOffset;
            long offsetInFile = totalOffset - outputFile.getFirstByteOffset();
            bytesToWrite = Math.min(remainingBytesToWrite, (int)(outputFile.getSize() - offsetInFile));
            if (offsetInFile < 0L) {
                throw new IOException("Cannot seek to position: " + offsetInFile);
            }
            Object object = outputFile.fileLock;
            synchronized (object) {
                RandomAccessFile file = outputFile.getFileAccess();
                file.seek(offsetInFile);
                file.write(blockData, dataOffset, bytesToWrite);
                continue;
            }
        }
    }

    public long countRemainingBytes() {
        return this.blocks.stream().filter(b -> b.getStatus() != BlockStatus.Verified).mapToLong(Block::getSize).sum();
    }

    public void setBlockStatus(int blockIndex, BlockStatus blockStatus) {
        if (blockIndex < 0 || blockIndex >= this.blocks.size()) {
            throw new IllegalArgumentException(String.format(ERR_BLOCK_IS_NOT_WITHIN_PIECE, blockIndex, this.blocks.size(), this));
        }
        this.blocks.get(blockIndex).setStatus(blockStatus);
    }

    public BlockStatus getBlockStatus(int blockIndex) {
        if (blockIndex < 0 || blockIndex >= this.blocks.size()) {
            throw new IllegalArgumentException(String.format(ERR_BLOCK_IS_NOT_WITHIN_PIECE, blockIndex, this.blocks.size(), this));
        }
        return this.blocks.get(blockIndex).getStatus();
    }

    public boolean isDone() {
        return this.blocks.stream().allMatch(b -> b.getStatus() == BlockStatus.Verified);
    }

    public boolean isStarted() {
        return this.blocks.stream().anyMatch(b -> b.getStatus() != BlockStatus.Needed);
    }

    public int getBlockCount() {
        return this.blocks.size();
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.blocks.stream().mapToInt(Block::getSize).sum();
    }

    public int countBlocksWithStatus(BlockStatus status) {
        return (int)this.blocks.stream().filter(block -> block.getStatus() == status).count();
    }

    public boolean hasBlockWithStatus(BlockStatus status) {
        return this.blocks.stream().anyMatch(block -> block.getStatus() == status);
    }

    public Optional<Block> getRequestBlock() {
        return this.blocks.stream().filter(p -> p.getStatus() == BlockStatus.Needed).findAny();
    }

    public int getBlockSize(int blockIndex) {
        if (blockIndex < 0 || blockIndex >= this.blocks.size()) {
            throw new IllegalArgumentException(String.format(ERR_BLOCK_IS_NOT_WITHIN_PIECE, blockIndex, this.blocks.size(), this));
        }
        return this.blocks.get(blockIndex).getSize();
    }

    public AbstractFileSet getFileSet() {
        return this.files;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Piece)) {
            return false;
        }
        Piece other = (Piece)obj;
        return this.index == other.index;
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public String toString() {
        return String.format("Piece[index=%d, hash=%s]", this.index, StringUtils.byteArrayToString(this.expectedHash));
    }
}

