/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.peer;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageChoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageInterested;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageKeepAlive;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUnchoke;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageUninterested;
import org.johnnei.javatorrent.disk.DiskJobReadBlock;
import org.johnnei.javatorrent.internal.torrent.peer.Bitfield;
import org.johnnei.javatorrent.internal.torrent.peer.Client;
import org.johnnei.javatorrent.internal.torrent.peer.Job;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.johnnei.javatorrent.utils.Argument;
import org.johnnei.javatorrent.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Peer.class);
    private static final String LOG_OUTSTANDING_BLOCK_REQUESTS = "Outstanding block requests [{}]";
    private final Torrent torrent;
    private final String idString;
    private final byte[] id;
    private final Client peerClient;
    private final Client myClient;
    private String clientName;
    private int pendingMessages;
    private int strikes;
    private Bitfield haveState;
    private final byte[] extensionBytes;
    private int absoluteRequestLimit;
    private int requestLimit;
    private final BitTorrentSocket socket;
    private Map<Class<?>, Object> extensions;

    private Peer(Builder builder) {
        this.torrent = Argument.requireNonNull(builder.torrent, "Peer must be assigned to a torrent.");
        this.socket = Argument.requireNonNull(builder.socket, "Peer must have a socket.");
        this.extensionBytes = Argument.requireNonNull(builder.extensionBytes, "Peer extension bytes must be set.");
        this.id = Argument.requireNonNull(builder.id, "Peer ID must be set.");
        this.idString = StringUtils.byteArrayToString(this.id);
        this.peerClient = new Client();
        this.myClient = new Client();
        this.extensions = new HashMap();
        this.clientName = this.idString;
        this.absoluteRequestLimit = Integer.MAX_VALUE;
        this.haveState = this.torrent.getFileSet() != null ? new Bitfield(this.torrent.getFileSet().getBitfieldBytes().length) : new Bitfield(0);
        this.requestLimit = 1;
    }

    public void addModuleInfo(Object infoObject) {
        Class<?> infoClass = infoObject.getClass();
        if (this.extensions.containsKey(infoClass)) {
            throw new IllegalStateException(String.format("Module Info already registered: %s", infoClass.getName()));
        }
        this.extensions.put(infoClass, infoObject);
    }

    public <T> Optional<T> getModuleInfo(Class<T> infoClass) {
        if (!this.extensions.containsKey(infoClass)) {
            return Optional.empty();
        }
        return Optional.of(this.extensions.get(infoClass));
    }

    public boolean hasExtension(int index, int bit) {
        Argument.requireWithinBounds(index, 0, this.extensionBytes.length, "Index must be: 0 >= index < 8");
        return (this.extensionBytes[index] & bit) > 0;
    }

    public void checkDisconnect() {
        if (this.strikes >= 5) {
            this.socket.close();
            return;
        }
        Duration inactiveDuration = Duration.between(this.socket.getLastActivity(), LocalDateTime.now());
        if (inactiveDuration.minusSeconds(30L).isNegative()) {
            return;
        }
        this.socket.enqueueMessage(new MessageKeepAlive());
    }

    public boolean addBlockRequest(Piece piece, int byteOffset, int blockLength, PeerDirection type) {
        Client client = this.getClientByDirection(type);
        if (client.isChoked()) {
            return false;
        }
        Job job = this.createJob(piece, byteOffset, blockLength, type);
        client.addJob(job);
        if (type != PeerDirection.Download) {
            return true;
        }
        LOGGER.trace(LOG_OUTSTANDING_BLOCK_REQUESTS, (Object)this.getClientByDirection(PeerDirection.Download).getQueueSize());
        this.socket.enqueueMessage(piece.getFileSet().getRequestFactory().createRequestFor(this, piece, byteOffset, blockLength));
        return true;
    }

    public void cancelBlockRequest(Piece piece, int byteOffset, int blockLength, PeerDirection type) {
        if (!piece.getFileSet().getRequestFactory().supportsCancellation()) {
            throw new IllegalArgumentException(String.format("The file set of %s doesn't support cancelling piece requests.", piece));
        }
        Job job = this.createJob(piece, byteOffset, blockLength, type);
        this.getClientByDirection(type).removeJob(job);
        if (type != PeerDirection.Download) {
            return;
        }
        this.socket.enqueueMessage(piece.getFileSet().getRequestFactory().createCancelRequestFor(this, piece, byteOffset, blockLength));
        LOGGER.trace(LOG_OUTSTANDING_BLOCK_REQUESTS, (Object)this.getClientByDirection(PeerDirection.Download).getQueueSize());
    }

    public void onReceivedBlock(Piece piece, int byteOffset) {
        int blockLength = piece.getBlockSize(byteOffset / this.torrent.getFileSet().getBlockSize());
        this.getClientByDirection(PeerDirection.Download).removeJob(this.createJob(piece, byteOffset, blockLength, PeerDirection.Download));
        LOGGER.trace(LOG_OUTSTANDING_BLOCK_REQUESTS, (Object)this.getClientByDirection(PeerDirection.Download).getQueueSize());
    }

    private Job createJob(Piece piece, int byteOffset, int blockLength, PeerDirection type) {
        if (type == PeerDirection.Download) {
            return new Job(piece, byteOffset / piece.getFileSet().getBlockSize(), blockLength);
        }
        return new Job(piece, byteOffset, blockLength);
    }

    private synchronized void addToPendingMessages(int i) {
        this.pendingMessages += i;
    }

    public String toString() {
        return String.format("Peer[id=%s]", this.idString);
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void onTorrentPhaseChange() {
        if (!this.torrent.isDownloadingMetadata()) {
            this.haveState.setSize(this.torrent.getFileSet().getBitfieldBytes().length);
        }
    }

    public int getFreeWorkTime() {
        return Math.max(0, this.getRequestLimit() - this.getWorkQueueSize(PeerDirection.Download));
    }

    public int getWorkQueueSize(PeerDirection direction) {
        return this.getClientByDirection(direction).getQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardAllBlockRequests() {
        Peer peer = this;
        synchronized (peer) {
            for (Job job : this.myClient.getJobs()) {
                job.getPiece().setBlockStatus(job.getBlockIndex(), BlockStatus.Needed);
            }
            this.myClient.clearJobs();
        }
    }

    public void setHavingPiece(int pieceIndex) {
        this.haveState.havePiece(pieceIndex, this.torrent.isDownloadingMetadata());
    }

    public boolean hasPiece(int pieceIndex) {
        return this.haveState.hasPiece(pieceIndex);
    }

    public LocalDateTime getLastActivity() {
        return this.socket.getLastActivity();
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public synchronized void addStrike(int i) {
        this.strikes = Math.max(0, this.strikes + i);
    }

    public void setAbsoluteRequestLimit(int absoluteRequestLimit) {
        this.absoluteRequestLimit = absoluteRequestLimit;
        this.setRequestLimit(Math.min(absoluteRequestLimit, this.getRequestLimit()));
    }

    public void setRequestLimit(int requestLimit) {
        if (requestLimit < 0) {
            return;
        }
        this.requestLimit = Math.min(requestLimit, this.absoluteRequestLimit);
        LOGGER.trace("Request limit is now [{}]", (Object)this.requestLimit);
    }

    public void setChoked(PeerDirection direction, boolean choked) {
        Client client = this.getClientByDirection(direction);
        if (choked) {
            client.choke();
        } else {
            client.unchoke();
        }
        if (direction == PeerDirection.Upload) {
            if (choked) {
                this.socket.enqueueMessage(new MessageChoke());
            } else {
                this.socket.enqueueMessage(new MessageUnchoke());
            }
        }
    }

    public void setInterested(PeerDirection direction, boolean interested) {
        Client client = this.getClientByDirection(direction);
        if (interested) {
            client.interested();
        } else {
            client.uninterested();
        }
        if (direction == PeerDirection.Download) {
            if (interested) {
                this.socket.enqueueMessage(new MessageInterested());
            } else {
                this.socket.enqueueMessage(new MessageUninterested());
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Peer)) {
            return false;
        }
        Peer other = (Peer)o;
        return Arrays.equals(this.id, other.id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }

    public boolean isInterested(PeerDirection direction) {
        return this.getClientByDirection(direction).isInterested();
    }

    public boolean isChoked(PeerDirection direction) {
        return this.getClientByDirection(direction).isChoked();
    }

    private Client getClientByDirection(PeerDirection type) {
        switch (type) {
            case Download: {
                return this.myClient;
            }
            case Upload: {
                return this.peerClient;
            }
        }
        throw new IllegalArgumentException("Missing enum type: " + (Object)((Object)type));
    }

    public int countHavePieces() {
        return this.haveState.countHavePieces();
    }

    @Deprecated
    public BitTorrentSocket getBitTorrentSocket() {
        return this.socket;
    }

    public void queueNextPieceForSending() {
        while (this.pendingMessages < 5) {
            Job request = this.peerClient.popNextJob();
            if (request == null) {
                return;
            }
            this.addToPendingMessages(1);
            this.torrent.addDiskJob(new DiskJobReadBlock(request.getPiece(), request.getBlockIndex(), request.getLength(), this::onReadBlockComplete));
        }
    }

    public String getIdAsString() {
        return this.idString;
    }

    private void onReadBlockComplete(DiskJobReadBlock readJob) {
        byte[] data = readJob.getBlockData();
        this.socket.enqueueMessage(new MessageBlock(readJob.getPiece().getIndex(), readJob.getOffset(), data));
        this.addToPendingMessages(-1);
        this.torrent.addUploadedBytes(data.length);
    }

    public static final class Builder {
        private BitTorrentSocket socket;
        private Torrent torrent;
        byte[] extensionBytes;
        byte[] id;

        public Builder setSocket(BitTorrentSocket socket) {
            this.socket = socket;
            return this;
        }

        public Builder setTorrent(Torrent torrent) {
            this.torrent = torrent;
            return this;
        }

        public Builder setExtensionBytes(byte[] extensionBytes) {
            Argument.requireNonNull(extensionBytes, "Extension bytes can not be null");
            if (extensionBytes.length != 8) {
                throw new IllegalArgumentException("Extension bytes are defined to be 8 bytes. (BEP #03)");
            }
            this.extensionBytes = extensionBytes;
            return this;
        }

        public Builder setId(byte[] id) {
            Argument.requireNonNull(id, "Id can not be null");
            if (id.length != 20) {
                throw new IllegalArgumentException("Id bytes are defined to be 20 bytes. (BEP #03)");
            }
            this.id = id;
            return this;
        }

        public Peer build() {
            return new Peer(this);
        }
    }
}

