/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.Clock;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.internal.network.connector.PeerConnectionQueue;
import org.johnnei.javatorrent.internal.network.connector.PeerConnectionState;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.network.socket.ISocket;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioPeerConnector
implements IPeerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioPeerConnector.class);
    private final Clock clock;
    private final TorrentClient torrentClient;
    private final int maxConcurrentConnecting;
    private final PeerConnectionQueue connectQueue;
    private final Selector connected;
    private ScheduledFuture<?> pollTask;

    public NioPeerConnector(TorrentClient torrentClient, int maxConcurrentConnecting) {
        this(Clock.systemDefaultZone(), torrentClient, maxConcurrentConnecting);
    }

    NioPeerConnector(Clock clock, TorrentClient torrentClient, int maxConcurrentConnecting) {
        this.clock = clock;
        this.torrentClient = torrentClient;
        this.maxConcurrentConnecting = maxConcurrentConnecting;
        this.connectQueue = new PeerConnectionQueue();
        try {
            this.connected = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create NIO selector", e);
        }
    }

    @Override
    public void enqueuePeer(PeerConnectInfo peer) {
        if (peer == null) {
            return;
        }
        LOGGER.debug("Enqueued {} for connecting.", (Object)peer);
        this.connectQueue.add(new PeerConnectionState(peer));
    }

    @Override
    public void start() {
        this.pollTask = this.torrentClient.getExecutorService().scheduleWithFixedDelay(this::pollReadyConnections, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.pollTask.cancel(false);
    }

    void pollReadyConnections() {
        try {
            this.updateReadyConnections();
            this.degradeTimedOutConnections();
            this.enqueueNewConnections();
        }
        catch (Exception e) {
            LOGGER.warn("Peer connector update failed", (Throwable)e);
        }
    }

    private void enqueueNewConnections() {
        PeerConnectionState state;
        for (int available = this.maxConcurrentConnecting - this.getConnectingCount(); available > 0 && (state = this.connectQueue.poll()) != null; --available) {
            this.degradeSocket(state, this.torrentClient.getConnectionDegradation().createPreferredSocket());
        }
    }

    private void degradeTimedOutConnections() {
        for (SelectionKey key : this.connected.keys()) {
            PeerConnectionState state = (PeerConnectionState)key.attachment();
            if (!this.clock.instant().minusSeconds(10L).isAfter(state.getStartTime())) continue;
            this.onDegradeSocket(state);
        }
    }

    private void onDegradeSocket(PeerConnectionState state) {
        Optional<ISocket> socket = this.torrentClient.getConnectionDegradation().degradeSocket(state.getCurrentSocket());
        try {
            state.getCurrentSocket().close();
        }
        catch (IOException e) {
            LOGGER.debug("Failed to close channel.", (Throwable)e);
        }
        this.degradeSocket(state, socket.orElse(null));
    }

    private void degradeSocket(PeerConnectionState state, ISocket socket) {
        block5: {
            if (socket != null) {
                try {
                    state.updateSocket(this.clock.instant(), socket);
                    if ((((SelectableChannel)socket.getReadableChannel()).validOps() & 8) != 0) {
                        ((SelectableChannel)socket.getReadableChannel()).register(this.connected, 8, state);
                        LOGGER.debug("Connecting to {} with socket type {}", (Object)state.getPeer().getAddress(), (Object)socket.getClass().getSimpleName());
                        socket.connect(state.getPeer().getAddress());
                        break block5;
                    }
                    LOGGER.debug("Socket type is connectionless, passing directly to handshake handler.");
                    socket.connect(state.getPeer().getAddress());
                    this.onConnected(state);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to start up connection", (Throwable)e);
                }
            } else {
                LOGGER.debug("Failed to establish connection with {}", (Object)state.getPeer().getAddress());
            }
        }
    }

    private void updateReadyConnections() {
        try {
            this.connected.selectNow();
            Iterator<SelectionKey> keys = this.connected.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                PeerConnectionState state = (PeerConnectionState)key.attachment();
                if (state.getCurrentSocket().isConnected()) {
                    this.onConnected(state);
                    key.cancel();
                } else {
                    this.onDegradeSocket(state);
                }
                keys.remove();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to establish connections to new peers", (Throwable)e);
        }
    }

    private void onConnected(PeerConnectionState state) {
        this.torrentClient.getHandshakeHandler().onConnectionEstablished(state.getCurrentSocket(), state.getPeer().getTorrent().getMetadata().getHash());
    }

    @Override
    public int getConnectingCount() {
        return this.connected.keys().size();
    }

    @Override
    public int getConnectingCountFor(Torrent torrent) {
        return (int)this.connected.keys().stream().map(key -> (PeerConnectionState)key.attachment()).filter(state -> state.getPeer().getTorrent().equals(torrent)).count();
    }
}

