/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Vector2f;

public class Matrix3f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m10;
    public float m20;
    public float m01;
    public float m11;
    public float m21;
    public float m02;
    public float m12;
    public float m22;

    public Matrix3f() {
        this.identity();
    }

    public Matrix3f(Matrix3f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
    }

    public Matrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3f set(Matrix3f m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        return this;
    }

    public Matrix3f mul(Matrix3f right) {
        return this.mul(right, this);
    }

    public Matrix3f mul(Matrix3f right, Matrix3f dest) {
        dest.set(this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02, this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02, this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02, this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12, this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12, this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12, this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22, this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22, this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22);
        return dest;
    }

    public Matrix3f set(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public Matrix3f set(float[] m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m10 = m[3];
        this.m11 = m[4];
        this.m12 = m[5];
        this.m20 = m[6];
        this.m21 = m[7];
        this.m22 = m[8];
        return this;
    }

    public float determinant() {
        return this.m00 * this.m11 * this.m22 + this.m10 * this.m21 * this.m02 + this.m20 * this.m01 * this.m12 - this.m20 * this.m11 * this.m02 - this.m00 * this.m21 * this.m12 - this.m10 * this.m01 * this.m22;
    }

    public Matrix3f invert() {
        return this.invert(this);
    }

    public Matrix3f invert(Matrix3f dest) {
        float s = this.determinant();
        s = 1.0f / s;
        dest.set((this.m11 * this.m22 - this.m21 * this.m12) * s, -(this.m01 * this.m22 - this.m21 * this.m02) * s, (this.m01 * this.m12 - this.m11 * this.m02) * s, -(this.m10 * this.m22 - this.m20 * this.m12) * s, (this.m00 * this.m22 - this.m20 * this.m02) * s, -(this.m00 * this.m12 - this.m10 * this.m02) * s, (this.m10 * this.m21 - this.m20 * this.m11) * s, -(this.m00 * this.m21 - this.m20 * this.m01) * s, (this.m00 * this.m11 - this.m10 * this.m01) * s);
        return dest;
    }

    public Matrix3f transpose() {
        return this.transpose(this);
    }

    public Matrix3f transpose(Matrix3f dest) {
        dest.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return dest;
    }

    public Matrix3f translation(float x, float y) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = x;
        this.m21 = y;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f translation(Vector2f offset) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = offset.x;
        this.m21 = offset.y;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f setTranslation(float x, float y) {
        this.m20 = x;
        this.m21 = y;
        return this;
    }

    public Matrix3f setTranslation(Vector2f offset) {
        this.m20 = offset.x;
        this.m21 = offset.y;
        return this;
    }

    public Matrix3f translate(float x, float y, Matrix3f dest) {
        float rm20 = x;
        float rm21 = y;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22;
        dest.m00 = this.m00;
        dest.m01 = this.m01;
        dest.m02 = this.m02;
        dest.m10 = this.m10;
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        return dest;
    }

    public Matrix3f translate(float x, float y) {
        return this.translate(x, y, this);
    }

    public Matrix3f translate(Vector2f offset, Matrix3f dest) {
        return this.translate(offset.x, offset.y, dest);
    }

    public Matrix3f translate(Vector2f offset) {
        return this.translate(offset.x, offset.y, this);
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat("  0.000E0; -");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return formatter.format(this.m00) + formatter.format(this.m10) + formatter.format(this.m20) + "\n" + formatter.format(this.m01) + formatter.format(this.m11) + formatter.format(this.m21) + "\n" + formatter.format(this.m02) + formatter.format(this.m12) + formatter.format(this.m22) + "\n";
    }

    public Matrix3f get(Matrix3f dest) {
        return dest.set(this);
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        buffer.put(index, this.m00);
        buffer.put(index + 1, this.m01);
        buffer.put(index + 2, this.m02);
        buffer.put(index + 3, this.m10);
        buffer.put(index + 4, this.m11);
        buffer.put(index + 5, this.m12);
        buffer.put(index + 6, this.m20);
        buffer.put(index + 7, this.m21);
        buffer.put(index + 8, this.m22);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        buffer.putFloat(index, this.m00);
        buffer.putFloat(index + 4, this.m01);
        buffer.putFloat(index + 8, this.m02);
        buffer.putFloat(index + 12, this.m10);
        buffer.putFloat(index + 16, this.m11);
        buffer.putFloat(index + 20, this.m12);
        buffer.putFloat(index + 24, this.m20);
        buffer.putFloat(index + 28, this.m21);
        buffer.putFloat(index + 32, this.m22);
        return buffer;
    }

    public Matrix3f set(FloatBuffer buffer) {
        int pos = buffer.position();
        this.m00 = buffer.get(pos);
        this.m01 = buffer.get(pos + 1);
        this.m02 = buffer.get(pos + 2);
        this.m10 = buffer.get(pos + 3);
        this.m11 = buffer.get(pos + 4);
        this.m12 = buffer.get(pos + 5);
        this.m20 = buffer.get(pos + 6);
        this.m21 = buffer.get(pos + 7);
        this.m22 = buffer.get(pos + 8);
        return this;
    }

    public Matrix3f set(ByteBuffer buffer) {
        int pos = buffer.position();
        this.m00 = buffer.getFloat(pos);
        this.m01 = buffer.getFloat(pos + 4);
        this.m02 = buffer.getFloat(pos + 8);
        this.m10 = buffer.getFloat(pos + 12);
        this.m11 = buffer.getFloat(pos + 16);
        this.m12 = buffer.getFloat(pos + 20);
        this.m20 = buffer.getFloat(pos + 24);
        this.m21 = buffer.getFloat(pos + 28);
        this.m22 = buffer.getFloat(pos + 32);
        return this;
    }

    public Matrix3f zero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        return this;
    }

    public Matrix3f identity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f scale(float x, float y, Matrix3f dest) {
        dest.m00 = this.m00 * x;
        dest.m01 = this.m01 * x;
        dest.m02 = this.m02 * x;
        dest.m10 = this.m10 * y;
        dest.m11 = this.m11 * y;
        dest.m12 = this.m12 * y;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        return dest;
    }

    public Matrix3f scale(float x, float y) {
        return this.scale(x, y, this);
    }

    public Matrix3f scale(float xy, Matrix3f dest) {
        return this.scale(xy, xy, dest);
    }

    public Matrix3f scale(float xy) {
        return this.scale(xy, xy);
    }

    public Matrix3f scaling(float factor) {
        this.m00 = factor;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = factor;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f scaling(float x, float y) {
        this.m00 = x;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = y;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f rotation(float angle) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        this.m00 = cos;
        this.m10 = -sin;
        this.m20 = 0.0f;
        this.m01 = sin;
        this.m11 = cos;
        this.m21 = 0.0f;
        this.m02 = 0.0f;
        this.m12 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f transform(Vector2f v) {
        v.mul(this);
        return this;
    }

    public Vector2f transform(Vector2f v, Vector2f dest) {
        v.mul(this, dest);
        return dest;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.m00);
        out.writeFloat(this.m01);
        out.writeFloat(this.m02);
        out.writeFloat(this.m10);
        out.writeFloat(this.m11);
        out.writeFloat(this.m12);
        out.writeFloat(this.m20);
        out.writeFloat(this.m21);
        out.writeFloat(this.m22);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m00 = in.readFloat();
        this.m01 = in.readFloat();
        this.m02 = in.readFloat();
        this.m10 = in.readFloat();
        this.m11 = in.readFloat();
        this.m12 = in.readFloat();
        this.m20 = in.readFloat();
        this.m21 = in.readFloat();
        this.m22 = in.readFloat();
    }

    public Matrix3f rotate(float ang) {
        return this.rotate(ang, this);
    }

    public Matrix3f rotate(float ang, Matrix3f dest) {
        float cos = (float)Math.cos(ang);
        float sin = (float)Math.sin(ang);
        float rm00 = cos;
        float rm01 = sin;
        float rm10 = -sin;
        float rm11 = cos;
        float nm00 = this.m00 * rm00 + this.m10 * rm01;
        float nm01 = this.m01 * rm00 + this.m11 * rm01;
        float nm02 = this.m02 * rm00 + this.m12 * rm01;
        dest.m10 = this.m00 * rm10 + this.m10 * rm11;
        dest.m11 = this.m01 * rm10 + this.m11 * rm11;
        dest.m12 = this.m02 * rm10 + this.m12 * rm11;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        return dest;
    }

    public Matrix3f rotateTo(Vector2f fromDir, Vector2f toDir, Matrix3f dest) {
        float dot = fromDir.x * toDir.x + fromDir.y * toDir.y;
        float det = fromDir.x * toDir.y - fromDir.y * toDir.x;
        float rm00 = dot;
        float rm01 = det;
        float rm10 = -det;
        float rm11 = dot;
        float nm00 = this.m00 * rm00 + this.m10 * rm01;
        float nm01 = this.m01 * rm00 + this.m11 * rm01;
        float nm02 = this.m02 * rm00 + this.m12 * rm01;
        dest.m10 = this.m00 * rm10 + this.m10 * rm11;
        dest.m11 = this.m01 * rm10 + this.m11 * rm11;
        dest.m12 = this.m02 * rm10 + this.m12 * rm11;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        return dest;
    }

    public Matrix3f rotateTo(Vector2f fromDir, Vector2f toDir) {
        return this.rotateTo(fromDir, toDir, this);
    }

    public Matrix3f view(float left, float right, float bottom, float top, Matrix3f dest) {
        float rm00 = 2.0f / (right - left);
        float rm11 = 2.0f / (top - bottom);
        float rm20 = -(right + left) / (right - left);
        float rm21 = -(top + bottom) / (top - bottom);
        float rm22 = -1.0f;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22 + this.m20;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22 + this.m21;
        dest.m22 = 1.0f;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        return dest;
    }

    public Matrix3f view(float left, float right, float bottom, float top) {
        return this.view(left, right, bottom, top, this);
    }

    public Matrix3f setView(float left, float right, float bottom, float top) {
        this.m00 = 2.0f / (right - left);
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 2.0f / (top - bottom);
        this.m12 = 0.0f;
        this.m20 = -(right + left) / (right - left);
        this.m21 = -(top + bottom) / (top - bottom);
        this.m22 = -1.0f;
        return this;
    }
}

