/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Site;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotCompiledNmethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.runtime.JVMCIBackend;
import jdk.vm.ci.runtime.JVMCIRuntime;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Options;
import org.joml.Quaternionf;
import sun.misc.Unsafe;

class JvmciCode {
    static final boolean canUseJvmci;
    static final byte[] MATRIX4D_MUL_AVX_LINUX;
    static final byte[] MATRIX4D_MUL_AVX_WINDOWS;
    static final byte[] MATRIX4F_MUL_AVX_LINUX;
    static final byte[] MATRIX4F_MUL_AVX_WINDOWS;
    static final byte[] MATRIX4F_INVERT_AVX_LINUX;
    static final byte[] MATRIX4F_INVERT_AVX_WINDOWS;
    static final byte[] MATRIX4F_TRANSPOSE_AVX_LINUX;
    static final byte[] MATRIX4F_TRANSPOSE_AVX_WINDOWS;
    static final byte[] MATRIX4F_SET_AVX_LINUX;
    static final byte[] MATRIX4F_SET_AVX_WINDOWS;
    static final byte[] QUATERNIONF_MUL_AVX_LINUX;
    static final byte[] QUATERNIONF_MUL_AVX_WINDOWS;

    JvmciCode() {
    }

    private static void checkMatrix4f() throws Throwable {
        Unsafe u = JvmciCode.unsafeInstance();
        for (int i = 0; i < 16; ++i) {
            int c = i >>> 2;
            int r = i & 3;
            Field f = Matrix4f.class.getDeclaredField("m" + c + r);
            long offset = u.objectFieldOffset(f);
            if (offset != (long)(16 + (i << 2))) {
                throw new AssertionError((Object)"invalid Matrix4f field offset");
            }
        }
    }

    private static void checkMatrix4d() throws Throwable {
        Unsafe u = JvmciCode.unsafeInstance();
        for (int i = 0; i < 16; ++i) {
            int c = i >>> 2;
            int r = i & 3;
            Field f = Matrix4d.class.getDeclaredField("m" + c + r);
            long offset = u.objectFieldOffset(f);
            if (offset != (long)(16 + (i << 3))) {
                throw new AssertionError((Object)"invalid Matrix4d field offset");
            }
        }
    }

    private static void checkQuaternionf() throws Throwable {
        Unsafe u = JvmciCode.unsafeInstance();
        if (u.objectFieldOffset(Quaternionf.class.getDeclaredField("w")) != 16L || u.objectFieldOffset(Quaternionf.class.getDeclaredField("x")) != 20L || u.objectFieldOffset(Quaternionf.class.getDeclaredField("y")) != 24L || u.objectFieldOffset(Quaternionf.class.getDeclaredField("z")) != 28L) {
            throw new AssertionError((Object)"invalid Quaternionf field offset");
        }
    }

    private static Unsafe unsafeInstance() throws SecurityException {
        Field[] fields = Unsafe.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers;
            Field field = fields[i];
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            try {
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
        }
        throw new AssertionError((Object)"no sun.misc.Unsafe available");
    }

    private static void installCode(JVMCIBackend jvmciBackend, Method m, byte[] code) throws Throwable {
        ResolvedJavaMethod rm = jvmciBackend.getMetaAccess().lookupJavaMethod((Executable)m);
        HotSpotCompiledNmethod nm = new HotSpotCompiledNmethod(m.getName(), code, code.length, new Site[0], new Assumptions.Assumption[0], new ResolvedJavaMethod[0], new HotSpotCompiledCode.Comment[0], new byte[0], 1, new DataPatch[0], true, 0, null, (HotSpotResolvedJavaMethod)rm, -1, 1, 0L, false);
        CodeCacheProvider codeCache = jvmciBackend.getCodeCache();
        Method setDefaultCodeMethod = codeCache.getClass().getMethod("setDefaultCode", ResolvedJavaMethod.class, CompiledCode.class);
        setDefaultCodeMethod.invoke((Object)codeCache, rm, nm);
    }

    static native void __Matrix4f_mul(Matrix4f var0, Matrix4f var1, Matrix4f var2);

    static native void __Matrix4d_mul(Matrix4d var0, Matrix4d var1, Matrix4d var2);

    static native void __Matrix4f_invert(Matrix4f var0, Matrix4f var1);

    static native void __Matrix4f_transpose(Matrix4f var0, Matrix4f var1);

    static native void __Matrix4f_set(Matrix4f var0, Matrix4f var1);

    static native void __Quaternionf_mul(Quaternionf var0, Quaternionf var1, Quaternionf var2);

    static {
        boolean _canUseJvmci;
        block3: {
            MATRIX4D_MUL_AVX_LINUX = new byte[]{-60, -30, 125, 25, 98, 16, -59, -3, 16, 94, 16, -59, -3, 16, 86, 48, -59, -3, 16, 78, 80, -59, -3, 16, 70, 112, -59, -35, 89, -29, -60, -30, 125, 25, 106, 24, -60, -30, -19, -88, -20, -60, -30, 125, 25, 114, 32, -60, -30, -11, -88, -11, -60, -30, 125, 25, 98, 40, -60, -30, -3, -88, -26, -60, -30, 125, 25, 106, 48, -59, -43, 89, -21, -60, -30, 125, 25, 114, 56, -60, -30, -19, -88, -11, -60, -30, 125, 25, 106, 64, -60, -30, -11, -88, -18, -60, -30, 125, 25, 114, 72, -60, -30, -3, -88, -11, -60, -30, 125, 25, 106, 80, -59, -43, 89, -21, -60, -30, 125, 25, 122, 88, -60, -30, -19, -88, -3, -60, -30, 125, 25, 106, 96, -60, -30, -11, -88, -17, -60, -30, 125, 25, 122, 104, -60, -30, -3, -88, -3, -60, -30, 125, 25, 106, 112, -59, -43, 89, -37, -60, -30, 125, 25, 106, 120, -60, -30, -19, -88, -21, -60, -30, 125, 25, -110, -128, 0, 0, 0, -60, -30, -11, -88, -43, -60, -30, 125, 25, -118, -120, 0, 0, 0, -60, -30, -3, -88, -54, -59, -3, 17, 97, 16, -59, -3, 17, 113, 48, -59, -3, 17, 121, 80, -59, -3, 17, 73, 112, -59, -8, 119, -61};
            MATRIX4D_MUL_AVX_WINDOWS = new byte[]{-60, -62, 125, 25, 96, 16, -59, -3, 16, 90, 16, -59, -3, 16, 82, 48, -59, -3, 16, 74, 80, -59, -3, 16, 66, 112, -59, -35, 89, -29, -60, -62, 125, 25, 104, 24, -60, -30, -19, -88, -20, -60, -62, 125, 25, 112, 32, -60, -30, -11, -88, -11, -60, -62, 125, 25, 96, 40, -60, -30, -3, -88, -26, -60, -62, 125, 25, 104, 48, -59, -43, 89, -21, -60, -62, 125, 25, 112, 56, -60, -30, -19, -88, -11, -60, -62, 125, 25, 104, 64, -60, -30, -11, -88, -18, -60, -62, 125, 25, 112, 72, -60, -30, -3, -88, -11, -60, -62, 125, 25, 104, 80, -59, -43, 89, -21, -60, -62, 125, 25, 120, 88, -60, -30, -19, -88, -3, -60, -62, 125, 25, 104, 96, -60, -30, -11, -88, -17, -60, -62, 125, 25, 120, 104, -60, -30, -3, -88, -3, -60, -62, 125, 25, 104, 112, -59, -43, 89, -37, -60, -62, 125, 25, 104, 120, -60, -30, -19, -88, -21, -60, -62, 125, 25, -112, -128, 0, 0, 0, -60, -30, -11, -88, -43, -60, -62, 125, 25, -120, -120, 0, 0, 0, -60, -30, -3, -88, -54, -60, -63, 125, 17, 97, 16, -60, -63, 125, 17, 113, 48, -60, -63, 125, 17, 121, 80, -60, -63, 125, 17, 73, 112, -59, -8, 119, -61};
            MATRIX4F_MUL_AVX_LINUX = new byte[]{-59, -4, 16, 66, 16, -59, -4, 16, 74, 48, -60, -29, 125, 4, -48, 0, -60, -30, 125, 26, 94, 16, -59, -28, 89, -46, -60, -29, 125, 4, -32, 85, -60, -30, 125, 26, 110, 32, -60, -30, 85, -88, -30, -60, -29, 125, 4, -48, -86, -60, -30, 125, 26, 118, 48, -60, -30, 77, -88, -44, -60, -29, 125, 4, -64, -1, -60, -30, 125, 26, 102, 64, -60, -30, 93, -88, -62, -60, -29, 125, 4, -47, 0, -59, -28, 89, -46, -60, -29, 125, 4, -39, 85, -60, -30, 85, -88, -38, -60, -29, 125, 4, -47, -86, -60, -30, 77, -88, -45, -60, -29, 125, 4, -55, -1, -60, -30, 93, -88, -54, -59, -4, 17, 65, 16, -59, -4, 17, 73, 48, -59, -8, 119, -61};
            MATRIX4F_MUL_AVX_WINDOWS = new byte[]{-60, -63, 124, 16, 64, 16, -60, -63, 124, 16, 72, 48, -60, -29, 125, 4, -48, 0, -60, -30, 125, 26, 90, 16, -59, -28, 89, -46, -60, -29, 125, 4, -32, 85, -60, -30, 125, 26, 106, 32, -60, -30, 85, -88, -30, -60, -29, 125, 4, -48, -86, -60, -30, 125, 26, 114, 48, -60, -30, 77, -88, -44, -60, -29, 125, 4, -64, -1, -60, -30, 125, 26, 98, 64, -60, -30, 93, -88, -62, -60, -29, 125, 4, -47, 0, -59, -28, 89, -46, -60, -29, 125, 4, -39, 85, -60, -30, 85, -88, -38, -60, -29, 125, 4, -47, -86, -60, -30, 77, -88, -45, -60, -29, 125, 4, -55, -1, -60, -30, 93, -88, -54, -60, -63, 124, 17, 65, 16, -60, -63, 124, 17, 73, 48, -59, -8, 119, -61};
            MATRIX4F_INVERT_AVX_LINUX = new byte[]{-59, -5, 16, 70, 16, -59, -5, 16, 102, 24, -59, -5, 16, 78, 48, -59, -5, 16, 110, 56, -59, -8, 22, 86, 32, -59, -16, 22, 94, 64, -59, -24, -58, -61, -120, -59, -32, -58, -54, -35, -59, -40, 22, 118, 40, -59, 80, 22, 70, 72, -60, -63, 72, -58, -8, -120, -59, -72, -58, -26, -35, -59, -40, 89, -17, -60, -29, 121, 4, -19, -79, -60, 99, 121, 5, -51, 1, -59, -80, 92, -19, -59, 80, 89, -39, -59, 64, 89, -55, -60, 67, 121, 4, -55, -79, -59, 48, 89, -28, -60, 67, 121, 5, -23, 1, -60, 65, 16, 92, -55, -59, 120, 41, 76, 36, -24, -59, 104, -58, -45, 119, -59, 56, -58, -10, 119, -60, 65, 8, 89, -14, -60, 99, 121, 5, -41, 1, -60, -63, 8, 89, -6, -59, -104, 88, -1, -59, -96, 88, -1, -60, 67, 121, 5, -34, 1, -59, 16, 89, -28, -60, 65, 32, 89, -22, -60, 65, 24, 88, -27, -60, -63, 64, 92, -4, -60, 65, 32, 92, -34, -59, 32, 89, -40, -60, 67, 121, 5, -37, 1, -59, 112, 89, -32, -60, 67, 121, 4, -28, -79, -60, 67, 121, 5, -20, 1, -59, 88, 89, -16, -60, 67, 121, 4, -10, -79, -60, 65, 16, 92, -4, -59, 0, 89, -4, -60, 65, 0, 92, -37, -60, 67, 121, 5, -2, 1, -60, 65, 8, 92, -49, -59, 48, 89, -55, -60, 65, 32, 88, -55, -59, -24, -58, -45, 34, -59, -72, -58, -34, 34, -59, -32, 89, -46, -60, -29, 121, 5, -38, 1, -59, -24, 92, -13, -59, -56, 89, -28, -60, -63, 0, 92, -10, -59, -88, 89, -10, -59, -56, 88, -28, -59, -48, 89, -24, -60, -29, 121, 5, -19, 1, -59, -48, 88, -28, -59, -32, 92, -46, -59, -24, 89, -55, -60, -63, 24, 92, -43, -59, -88, 89, -46, -59, -8, 89, 92, 36, -24, -60, -29, 121, 5, -37, 1, -59, -24, 92, -45, -59, -24, 88, -55, -59, -64, 89, -64, -60, -29, 121, 5, -48, 1, -59, -24, 88, -64, -59, -6, 22, -48, -59, -8, 88, -62, -59, -6, 83, -48, -59, -22, 89, -38, -59, -30, 89, -64, -59, -22, 88, -46, -59, -22, 92, -64, -60, -29, 121, 4, -64, 0, -59, -8, 89, -44, -59, -8, 17, 82, 32, -59, -8, 89, -41, -59, -8, 17, 82, 16, -59, -80, 89, -48, -59, -8, 89, -63, -59, -8, 17, 66, 64, -59, -8, 17, 82, 48, -61};
            MATRIX4F_INVERT_AVX_WINDOWS = new byte[]{-59, -5, 16, 66, 16, -59, -5, 16, 98, 24, -59, -5, 16, 74, 48, -59, -5, 16, 106, 56, -59, -8, 22, 82, 32, -59, -16, 22, 90, 64, -59, -24, -58, -61, -120, -59, -32, -58, -54, -35, -59, -40, 22, 114, 40, -59, 80, 22, 66, 72, -60, -63, 72, -58, -8, -120, -59, -72, -58, -26, -35, -59, -40, 89, -17, -60, -29, 121, 4, -19, -79, -60, 99, 121, 5, -51, 1, -59, -80, 92, -19, -59, 80, 89, -39, -59, 64, 89, -55, -60, 67, 121, 4, -55, -79, -59, 48, 89, -28, -60, 67, 121, 5, -23, 1, -60, 65, 16, 92, -55, -59, 120, 41, 76, 36, -24, -59, 104, -58, -45, 119, -59, 56, -58, -10, 119, -60, 65, 8, 89, -14, -60, 99, 121, 5, -41, 1, -60, -63, 8, 89, -6, -59, -104, 88, -1, -59, -96, 88, -1, -60, 67, 121, 5, -34, 1, -59, 16, 89, -28, -60, 65, 32, 89, -22, -60, 65, 24, 88, -27, -60, -63, 64, 92, -4, -60, 65, 32, 92, -34, -59, 32, 89, -40, -60, 67, 121, 5, -37, 1, -59, 112, 89, -32, -60, 67, 121, 4, -28, -79, -60, 67, 121, 5, -20, 1, -59, 88, 89, -16, -60, 67, 121, 4, -10, -79, -60, 65, 16, 92, -4, -59, 0, 89, -4, -60, 65, 0, 92, -37, -60, 67, 121, 5, -2, 1, -60, 65, 8, 92, -49, -59, 48, 89, -55, -60, 65, 32, 88, -55, -59, -24, -58, -45, 34, -59, -72, -58, -34, 34, -59, -32, 89, -46, -60, -29, 121, 5, -38, 1, -59, -24, 92, -13, -59, -56, 89, -28, -60, -63, 0, 92, -10, -59, -88, 89, -10, -59, -56, 88, -28, -59, -48, 89, -24, -60, -29, 121, 5, -19, 1, -59, -48, 88, -28, -59, -32, 92, -46, -59, -24, 89, -55, -60, -63, 24, 92, -43, -59, -88, 89, -46, -59, -8, 89, 92, 36, -24, -60, -29, 121, 5, -37, 1, -59, -24, 92, -45, -59, -24, 88, -55, -59, -64, 89, -64, -60, -29, 121, 5, -48, 1, -59, -24, 88, -64, -59, -6, 22, -48, -59, -8, 88, -62, -59, -6, 83, -48, -59, -22, 89, -38, -59, -30, 89, -64, -59, -22, 88, -46, -59, -22, 92, -64, -60, -29, 121, 4, -64, 0, -59, -8, 89, -44, -60, -63, 120, 17, 80, 32, -59, -8, 89, -41, -60, -63, 120, 17, 80, 16, -59, -80, 89, -48, -59, -8, 89, -63, -60, -63, 120, 17, 64, 64, -60, -63, 120, 17, 80, 48, -61};
            MATRIX4F_TRANSPOSE_AVX_LINUX = new byte[]{-59, -8, 16, 70, 16, -59, -8, 16, 78, 32, -59, -8, 16, 86, 48, -59, -8, 16, 94, 64, -59, -8, 20, -31, -59, -24, 20, -21, -59, -8, 21, -63, -59, -24, 21, -53, -59, -40, 22, -43, -59, -39, 21, -35, -59, -8, 22, -31, -59, -7, 21, -63, -59, -8, 17, 82, 16, -59, -8, 17, 90, 32, -59, -8, 17, 98, 48, -59, -8, 17, 66, 64, -61};
            MATRIX4F_TRANSPOSE_AVX_WINDOWS = new byte[]{-59, -8, 16, 66, 16, -59, -8, 16, 74, 32, -59, -8, 16, 82, 48, -59, -8, 16, 90, 64, -59, -8, 20, -31, -59, -24, 20, -21, -59, -8, 21, -63, -59, -24, 21, -53, -59, -40, 22, -43, -59, -39, 21, -35, -59, -8, 22, -31, -59, -7, 21, -63, -60, -63, 120, 17, 80, 16, -60, -63, 120, 17, 88, 32, -60, -63, 120, 17, 96, 48, -60, -63, 120, 17, 64, 64, -61};
            MATRIX4F_SET_AVX_LINUX = new byte[]{-59, -4, 16, 70, 16, -59, -4, 16, 78, 48, -59, -4, 17, 66, 16, -59, -4, 17, 74, 48, -59, -8, 119, -61};
            MATRIX4F_SET_AVX_WINDOWS = new byte[]{-59, -4, 16, 66, 16, -59, -4, 16, 74, 48, -60, -63, 124, 17, 64, 16, -60, -63, 124, 17, 72, 48, -59, -8, 119, -61};
            QUATERNIONF_MUL_AVX_LINUX = new byte[]{-59, -8, 16, 70, 16, -59, -8, 16, 74, 16, -60, -29, 121, 4, -48, -27, -60, -29, 121, 4, -40, 122, -60, -29, 121, 4, -31, 1, -59, -40, 89, -46, -60, -29, 121, 4, -31, -98, -60, -30, 97, -88, -30, -59, -40, 87, 21, 35, 0, 0, 0, -60, -29, 121, 4, -39, 123, -60, -30, 121, 24, 102, 16, -60, -29, 121, 4, -64, -97, -60, -30, 113, -88, -30, -60, -30, 97, -68, -32, -59, -8, 17, 97, 16, -61, -112, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            QUATERNIONF_MUL_AVX_WINDOWS = new byte[]{-59, -8, 16, 66, 16, -60, -63, 120, 16, 72, 16, -60, -29, 121, 4, -48, -27, -60, -29, 121, 4, -40, 122, -60, -29, 121, 4, -31, 1, -59, -40, 89, -46, -60, -29, 121, 4, -31, -98, -60, -30, 97, -88, -30, -59, -40, 87, 21, 36, 0, 0, 0, -60, -29, 121, 4, -39, 123, -60, -30, 121, 24, 98, 16, -60, -29, 121, 4, -64, -97, -60, -30, 113, -88, -30, -60, -30, 97, -68, -32, -60, -63, 120, 17, 97, 16, -61, -112, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            _canUseJvmci = false;
            try {
                boolean _isWindows = System.getProperty("os.name").contains("Windows");
                JVMCIRuntime jvmciRuntime = JVMCI.getRuntime();
                JVMCIBackend jvmciBackend = jvmciRuntime.getHostJVMCIBackend();
                TargetDescription targetDesc = jvmciBackend.getTarget();
                Architecture arch = targetDesc.arch;
                AMD64 amd64arch = (AMD64)arch;
                EnumSet features = amd64arch.getFeatures();
                if (!features.contains(AMD64.CPUFeature.AVX) || !features.contains(AMD64.CPUFeature.FMA)) {
                    throw new AssertionError((Object)"CPU lacks AVX or FMA support");
                }
                JvmciCode.checkMatrix4f();
                JvmciCode.checkMatrix4d();
                JvmciCode.checkQuaternionf();
                JvmciCode.installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_mul", Matrix4f.class, Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_MUL_AVX_WINDOWS : MATRIX4F_MUL_AVX_LINUX);
                JvmciCode.installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4d_mul", Matrix4d.class, Matrix4d.class, Matrix4d.class), _isWindows ? MATRIX4D_MUL_AVX_WINDOWS : MATRIX4D_MUL_AVX_LINUX);
                JvmciCode.installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_invert", Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_INVERT_AVX_WINDOWS : MATRIX4F_INVERT_AVX_LINUX);
                JvmciCode.installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_transpose", Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_TRANSPOSE_AVX_WINDOWS : MATRIX4F_TRANSPOSE_AVX_LINUX);
                JvmciCode.installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_set", Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_SET_AVX_WINDOWS : MATRIX4F_SET_AVX_LINUX);
                JvmciCode.installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Quaternionf_mul", Quaternionf.class, Quaternionf.class, Quaternionf.class), _isWindows ? QUATERNIONF_MUL_AVX_WINDOWS : QUATERNIONF_MUL_AVX_LINUX);
                _canUseJvmci = true;
            }
            catch (Throwable e) {
                if (!Options.DEBUG) break block3;
                System.out.println("[JOML] JVMCI not available, because: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        canUseJvmci = _canUseJvmci;
    }
}

