/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.akka;

import akka.actor.ActorSystem;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.jooby.Env;
import org.jooby.Jooby;

public class Akka
implements Jooby.Module {
    private boolean named;
    private String name;

    public Akka(String name) {
        this.name = Objects.requireNonNull(name, "ActorSystem's name is required.");
    }

    public Akka() {
        this("default");
    }

    public Akka named() {
        this.named = true;
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        ActorSystem sys = ActorSystem.create((String)this.name, (Config)conf);
        Key syskey = Key.get(ActorSystem.class);
        if (this.named) {
            syskey = Key.get(ActorSystem.class, (Annotation)Names.named((String)this.name));
        }
        binder.bind(syskey).toInstance((Object)sys);
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"akka.conf");
    }
}

