/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.typesafe.config.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jooby.MediaType;
import org.jooby.assets.AssetProcessor;
import org.jooby.assets.V8Context;

public class Jshint
extends AssetProcessor {
    public Jshint() {
        this.set("browser", true);
        this.set("devel", true);
        this.set("forin", true);
        this.set("noarg", true);
        this.set("noempty", true);
        this.set("eqeqeq", true);
        this.set("bitwise", true);
        this.set("undef", true);
        this.set("curly", true);
        this.set("trailing", true);
        this.set("white", true);
        this.set("globalstrict", false);
        this.set("strict", false);
    }

    public boolean matches(MediaType type) {
        return MediaType.js.matches(type);
    }

    public String process(String filename, String source, Config conf) throws Exception {
        return V8Context.run((String)"global", v8 -> {
            LinkedHashMap options = new LinkedHashMap(this.options());
            Map predef = (Map)options.remove("predef");
            options.remove("excludes");
            return v8.invoke("jshint.js", new Object[]{source, options, predef, filename});
        });
    }
}

