/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Managed;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.assets.AssetHandlerWithCompiler;
import org.jooby.internal.assets.LiveCompiler;

public class Assets
implements Jooby.Module {
    private Function<String, String> scripts = path -> "<script src=\"" + path + "\"></script>\n";
    private Function<String, String> styles = path -> "<link href=\"" + path + "\" rel=\"stylesheet\">\n";

    public void configure(Env env, Config config, Binder binder) {
        try {
            boolean dev = "dev".equals(env.name());
            ClassLoader loader = this.getClass().getClassLoader();
            Config conf = this.conf(dev, loader, config);
            AssetCompiler compiler = new AssetCompiler(loader, conf);
            Multibinder routes = Multibinder.newSetBinder((Binder)binder, Route.Definition.class);
            routes.addBinding().toInstance((Object)new Route.Definition("*", "*", (req, rsp) -> compiler.keySet().forEach(asset -> {
                List<String> styles = compiler.styles((String)asset);
                req.set(asset + "_css", styles);
                req.set(asset + "_styles", (Object)styles.stream().map(this.styles).collect(Collectors.joining()));
                List<String> scripts = compiler.scripts((String)asset);
                req.set(asset + "_js", scripts);
                req.set(asset + "_scripts", (Object)scripts.stream().map(this.scripts).collect(Collectors.joining()));
            })).name("/assets/vars"));
            boolean watch = dev;
            if (watch && conf.hasPath("assets.watch")) {
                watch = conf.getBoolean("assets.watch");
            }
            if (watch) {
                LiveCompiler liveCompiler = new LiveCompiler(conf, compiler);
                binder.bind(Managed.class).toInstance((Object)liveCompiler);
                routes.addBinding().toInstance((Object)new Route.Definition("*", "*", (Route.Handler)liveCompiler).name("/assets/compiler"));
            }
            AssetHandler handler = dev ? new AssetHandlerWithCompiler("/", compiler).etag(false).lastModified(false) : new AssetHandler("/").etag(conf.getBoolean("assets.etag")).cdn(conf.getString("assets.cdn")).lastModified(conf.getBoolean("assets.lastModified")).maxAge(conf.getDuration("assets.cache.maxAge", TimeUnit.SECONDS));
            compiler.patterns().forEach(pattern -> routes.addBinding().toInstance((Object)new Route.Definition("GET", pattern, (Route.Handler)handler)));
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private Config conf(boolean dev, ClassLoader loader, Config conf) {
        Config[] confs = dev ? new Config[]{ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf")} : new Config[]{ConfigFactory.parseResources((ClassLoader)loader, (String)("assets." + conf.getString("application.env").toLowerCase() + ".conf")), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.dist.conf"), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf")};
        Config result = confs[0];
        for (int i = 1; i < confs.length; ++i) {
            result = result.withFallback((ConfigMergeable)confs[i]);
        }
        return result.withFallback((ConfigMergeable)conf).resolve();
    }
}

