/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Watcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private volatile Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private BiConsumer<WatchEvent.Kind<?>, Path> listener;
    private Thread scanner;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public void start() {
        this.scanner.start();
    }

    public void stop() throws IOException {
        this.watcher.close();
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Watcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Watcher(BiConsumer<WatchEvent.Kind<?>, Path> listener, Path ... dirs) throws IOException {
        this.listener = listener;
        for (Path dir : dirs) {
            this.registerAll(dir);
        }
        this.scanner = new Thread(() -> {
            boolean process = true;
            listener.accept(StandardWatchEventKinds.ENTRY_MODIFY, dirs[0]);
            try {
                while (process) {
                    process = this.processEvents();
                }
            }
            catch (ClosedWatchServiceException ex) {
                this.log.trace("watch service closed", (Throwable)ex);
            }
        }, "asset-compiler");
        this.scanner.setDaemon(true);
    }

    private boolean processEvents() {
        WatchKey key;
        try {
            key = this.watcher.take();
        }
        catch (InterruptedException x) {
            return false;
        }
        Path dir = this.keys.get(key);
        if (dir == null) {
            return true;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
            WatchEvent ev = Watcher.cast(event);
            Path name = (Path)ev.context();
            Path child = dir.resolve(name);
            File file = child.toFile();
            if (file.isFile()) {
                this.listener.accept(kind, dir.resolve(name));
            }
            if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
            try {
                if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                this.registerAll(child);
            }
            catch (IOException x) {}
        }
        boolean valid = key.reset();
        if (!valid) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                return false;
            }
        }
        return true;
    }
}

