/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.TimeUnit;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Managed;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.assets.AssetHandlerWithCompiler;
import org.jooby.internal.assets.AssetVars;
import org.jooby.internal.assets.LiveCompiler;

public class Assets
implements Jooby.Module {
    public void configure(Env env, Config config, Binder binder) {
        try {
            boolean dev = "dev".equals(env.name());
            ClassLoader loader = this.getClass().getClassLoader();
            Config conf = this.conf(dev, loader, config);
            String cpath = config.getString("application.path");
            AssetCompiler compiler = new AssetCompiler(loader, conf);
            Multibinder routes = Multibinder.newSetBinder((Binder)binder, Route.Definition.class);
            routes.addBinding().toInstance((Object)new Route.Definition("*", "*", (Route.Handler)new AssetVars(compiler, cpath)).name("/assets/vars"));
            boolean watch = dev;
            if (watch && conf.hasPath("assets.watch")) {
                watch = conf.getBoolean("assets.watch");
            }
            if (watch) {
                LiveCompiler liveCompiler = new LiveCompiler(conf, compiler);
                binder.bind(Managed.class).toInstance((Object)liveCompiler);
                routes.addBinding().toInstance((Object)new Route.Definition("*", "*", (Route.Handler)liveCompiler).name("/assets/compiler"));
            }
            AssetHandler handler = dev ? new AssetHandlerWithCompiler("/", compiler).etag(false).lastModified(false) : new AssetHandler("/").etag(conf.getBoolean("assets.etag")).cdn(conf.getString("assets.cdn")).lastModified(conf.getBoolean("assets.lastModified")).maxAge(conf.getDuration("assets.cache.maxAge", TimeUnit.SECONDS));
            compiler.patterns().forEach(pattern -> routes.addBinding().toInstance((Object)new Route.Definition("GET", pattern, (Route.Handler)handler)));
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private Config conf(boolean dev, ClassLoader loader, Config conf) {
        if (!dev) {
            Config[] confs;
            for (Config it : confs = new Config[]{ConfigFactory.parseResources((ClassLoader)loader, (String)("assets." + conf.getString("application.env").toLowerCase() + ".conf")), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.dist.conf"), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf")}) {
                if (it.isEmpty()) continue;
                return it.withFallback((ConfigMergeable)conf).resolve();
            }
        }
        return ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf").withFallback((ConfigMergeable)conf).resolve();
    }
}

