/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.base.CaseFormat;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import java.util.Objects;
import org.jooby.MediaType;

public abstract class AssetProcessor {
    private Config options = ConfigFactory.empty();

    public AssetProcessor set(String name, Object value) {
        Objects.requireNonNull(name, "Option's name is required.");
        this.options = this.options.withValue(name, ConfigValueFactory.fromAnyRef((Object)value));
        return this;
    }

    public AssetProcessor set(Config options) {
        this.options = Objects.requireNonNull(options, "Options are required.").withFallback((ConfigMergeable)this.options);
        return this;
    }

    public Map<String, Object> options() {
        return this.options.withoutPath("excludes").root().unwrapped();
    }

    public <T> T get(String name) {
        Objects.requireNonNull(name, "Option's name is required.");
        if (this.options.hasPath(name)) {
            return (T)this.options.getAnyRef(name);
        }
        return null;
    }

    public final String name() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getClass().getSimpleName());
    }

    public abstract boolean matches(MediaType var1);

    public abstract String process(String var1, String var2, Config var3) throws Exception;

    public String toString() {
        return this.name();
    }
}

