/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jooby.assets.AssetProblem;

public class AssetException
extends RuntimeException
implements Supplier<String> {
    private List<AssetProblem> problems;
    private String id;

    public AssetException(String id, AssetProblem problem) {
        this(id, (List<AssetProblem>)ImmutableList.of((Object)problem));
    }

    public AssetException(String id, List<AssetProblem> problems) {
        super(Objects.requireNonNull(problems, "The problems is required.").stream().map(AssetProblem::toString).collect(Collectors.joining("\n", "\t", "")));
        this.id = id;
        this.problems = problems;
    }

    @Override
    public String get() {
        AssetProblem problem = this.problems.get(0);
        return problem.getMessage();
    }

    public String getId() {
        return this.id;
    }

    public List<AssetProblem> getProblems() {
        return this.problems;
    }
}

