/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;
import org.jooby.assets.AssetException;
import org.jooby.assets.AssetProblem;
import org.jooby.internal.assets.Watcher;

public class LiveCompiler
implements Route.Handler {
    private final Config conf;
    private final AssetCompiler compiler;
    private final AtomicReference<AssetException> lastErr = new AtomicReference<Object>(null);
    private final Watcher watcher;

    public LiveCompiler(Config conf, AssetCompiler compiler) throws IOException {
        this.conf = Objects.requireNonNull(conf, "Config is required.");
        this.compiler = Objects.requireNonNull(compiler, "Asset compiler is required.");
        this.watcher = new Watcher(this::onChange, Paths.get("public", new String[0]));
    }

    private void onChange(WatchEvent.Kind<?> kind, Path path) {
        File outputdir = new File(this.conf.getString("application.tmpdir"), "__public_");
        outputdir.mkdirs();
        try {
            this.compiler.build(this.conf.getString("application.env"), outputdir);
            this.lastErr.set(null);
        }
        catch (AssetException ex) {
            this.lastErr.set(this.rewrite(ex));
        }
        catch (Exception ex) {
            AssetException assetEx = this.rewrite(new AssetException("compiler", new AssetProblem(path.toString(), -1, -1, ex.getMessage(), null), (Throwable)ex));
            this.lastErr.set(assetEx);
        }
    }

    private AssetException rewrite(AssetException ex) {
        ArrayList stacktrace = Lists.newArrayList((Object[])ex.getStackTrace());
        List<AssetProblem> problems = ex.getProblems();
        AssetProblem head = problems.get(0);
        stacktrace.add(0, new StackTraceElement(head.getFilename(), "", head.getFilename(), head.getLine()));
        ex.setStackTrace(stacktrace.toArray(new StackTraceElement[stacktrace.size()]));
        return ex;
    }

    public void handle(Request req, Response rsp) throws Throwable {
        AssetException ex = this.lastErr.get();
        if (ex != null) {
            throw ex;
        }
    }

    public void start() {
        this.watcher.start();
    }

    public void stop() throws Exception {
        this.watcher.stop();
    }
}

