/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooby.Env;
import org.jooby.MediaType;
import org.jooby.assets.AssetException;
import org.jooby.assets.AssetProblem;
import org.jooby.assets.AssetProcessor;

public class Props
extends AssetProcessor {
    private static Pattern POS = Pattern.compile("at\\s(\\d+):(\\d+)");

    public Props() {
        this.set("delims", Arrays.asList("${", "}"));
    }

    @Override
    public boolean matches(MediaType type) {
        return true;
    }

    @Override
    public String process(String filename, String source, Config conf) throws Exception {
        try {
            Env env = Env.DEFAULT.build(conf);
            List delims = (List)this.get("delims");
            return env.resolve(source, (String)delims.get(0), (String)delims.get(1));
        }
        catch (Exception cause) {
            int line = -1;
            int column = -1;
            Matcher matcher = POS.matcher(cause.getMessage());
            if (matcher.find()) {
                line = Integer.parseInt(matcher.group(1));
                column = Integer.parseInt(matcher.group(2));
            }
            throw new AssetException(this.name(), new AssetProblem(filename, line, column, cause.getMessage(), null));
        }
    }
}

