/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import java.util.List;
import java.util.stream.Collectors;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;

public class AssetVars
implements Route.Handler {
    private AssetCompiler compiler;
    private String cpath;

    public AssetVars(AssetCompiler compiler, String cpath) {
        this.compiler = compiler;
        this.cpath = cpath.equals("/") ? "" : cpath;
    }

    public void handle(Request req, Response rsp) throws Exception {
        this.compiler.fileset().forEach(asset -> {
            List<String> styles = this.compiler.styles((String)asset);
            req.set(asset + "_css", styles);
            req.set(asset + "_styles", (Object)styles.stream().map(p -> "<link href=\"" + this.cpath + p + "\" rel=\"stylesheet\">\n").collect(Collectors.joining()));
            List<String> scripts = this.compiler.scripts((String)asset);
            req.set(asset + "_js", scripts);
            req.set(asset + "_scripts", (Object)scripts.stream().map(p -> "<script src=\"" + this.cpath + p + "\"></script>\n").collect(Collectors.joining()));
        });
    }
}

