/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.assets.AssetCompiler;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.assets.AssetHandlerWithCompiler;
import org.jooby.internal.assets.AssetVars;
import org.jooby.internal.assets.LiveCompiler;

public class Assets
implements Jooby.Module {
    public void configure(Env env, Config config, Binder binder) throws Throwable {
        boolean watch;
        String envname = env.name();
        boolean dev = "dev".equals(envname);
        ClassLoader loader = this.getClass().getClassLoader();
        Config conf = this.conf(dev, loader, config);
        String cpath = config.getString("application.path");
        AssetCompiler compiler = new AssetCompiler(loader, conf);
        Router routes = env.router();
        ImmutableList dist = dev ? ImmutableList.of((Object)"dev") : ImmutableList.of((Object)envname, (Object)"dist");
        String prefix = dist.stream().filter(it -> conf.hasPath("assets." + it + ".prefix")).findFirst().map(it -> conf.getString("assets." + it + ".prefix")).orElse(cpath);
        routes.use("*", "*", (Route.Handler)new AssetVars(compiler, prefix, !dev)).name("/assets/vars");
        boolean bl = watch = conf.hasPath("assets.watch") ? conf.getBoolean("assets.watch") : dev;
        if (watch) {
            LiveCompiler liveCompiler = new LiveCompiler(conf, compiler);
            env.onStart(liveCompiler::start);
            env.onStop(liveCompiler::stop);
            routes.use("*", "*", (Route.Handler)liveCompiler).name("/assets/compiler");
        }
        AssetHandlerWithCompiler handler = dev ? new AssetHandlerWithCompiler("/", compiler) : new AssetHandler("/");
        handler.etag(conf.getBoolean("assets.etag")).cdn(conf.getString("assets.cdn")).lastModified(conf.getBoolean("assets.lastModified"));
        handler.maxAge(conf.getString("assets.cache.maxAge"));
        compiler.patterns().forEach(pattern -> routes.get(pattern, (Route.Handler)handler));
    }

    private Config conf(boolean dev, ClassLoader loader, Config conf) {
        if (!dev) {
            Config[] confs;
            for (Config it : confs = new Config[]{ConfigFactory.parseResources((ClassLoader)loader, (String)("assets." + conf.getString("application.env").toLowerCase() + ".conf")), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.dist.conf"), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf")}) {
                if (it.isEmpty()) continue;
                return it.withFallback((ConfigMergeable)conf).resolve();
            }
        }
        return ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf").withFallback((ConfigMergeable)conf).resolve();
    }
}

