/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import java.util.List;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;
import org.jooby.funzy.Throwing;

public class AssetVars
implements Route.Handler {
    private AssetCompiler compiler;
    private String cpath;
    private Throwing.Function<String, List<String>> styles;
    private Throwing.Function<String, List<String>> scripts;

    public AssetVars(AssetCompiler compiler, String cpath, boolean cache) {
        this.compiler = compiler;
        this.cpath = cpath.equals("/") ? "" : cpath;
        this.styles = compiler::styles;
        this.scripts = compiler::scripts;
        if (cache) {
            this.styles = this.styles.memoized();
            this.scripts = this.scripts.memoized();
        }
    }

    public void handle(Request req, Response rsp) throws Exception {
        this.compiler.fileset().forEach(asset -> {
            List css = (List)this.styles.apply(asset);
            String styles = css.stream().reduce(new StringBuilder(), (buff, it) -> buff.append("<link href=\"").append(this.cpath).append((String)it).append("\" rel=\"stylesheet\">\n"), StringBuilder::append).toString();
            req.set(asset + "_css", (Object)css);
            req.set(asset + "_styles", (Object)styles);
            List js = (List)this.scripts.apply(asset);
            String scripts = js.stream().reduce(new StringBuilder(), (buff, it) -> buff.append("<script src=\"").append(this.cpath).append((String)it).append("\"></script>\n"), StringBuilder::append).toString();
            req.set(asset + "_js", (Object)js);
            req.set(asset + "_scripts", (Object)scripts);
        });
    }
}

