/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jooby.Asset;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;
import org.jooby.assets.AssetException;
import org.jooby.assets.AssetProblem;
import org.jooby.funzy.Try;
import org.jooby.internal.URLAsset;
import org.jooby.internal.assets.Watcher;

public class LiveCompiler
implements Route.Handler {
    private final Config conf;
    private final AssetCompiler compiler;
    private final Map<String, AssetException> errors = new ConcurrentHashMap<String, AssetException>();
    private final Watcher watcher;
    private final AtomicBoolean firstRun = new AtomicBoolean(true);
    private Path basedir;

    public LiveCompiler(Config conf, AssetCompiler compiler) throws IOException {
        this.conf = Objects.requireNonNull(conf, "Config is required.");
        this.compiler = Objects.requireNonNull(compiler, "Asset compiler is required.");
        this.basedir = Paths.get("public", new String[0]);
        this.watcher = new Watcher(this::onChange, this.basedir);
    }

    private void onChange(WatchEvent.Kind<?> kind, Path path) {
        File outputdir = new File(this.conf.getString("application.tmpdir"), "__public_");
        outputdir.mkdirs();
        String filename = Route.normalize((String)((String)Try.apply(() -> path.subpath(1, path.getNameCount()).toString()).orElse((Object)path.toString())));
        try {
            boolean firstRun = this.firstRun.compareAndSet(true, false);
            if (!(firstRun || path.equals(this.basedir) || this.compiler.contains(path.toString()))) {
                return;
            }
            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                this.errors.remove(filename);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                this.errors.clear();
                this.compiler.build(this.conf.getString("application.env"), outputdir);
            } else {
                MediaType type = MediaType.byPath((Path)path).orElse(MediaType.octetstream);
                this.compiler.build((Asset)new URLAsset(path.toUri().toURL(), filename, type));
                this.errors.remove(filename);
            }
        }
        catch (AssetException ex) {
            String localname = ex.getProblems().stream().findFirst().map(AssetProblem::getFilename).orElse(filename);
            this.errors.put(localname, this.rewrite(ex));
        }
        catch (Exception ex) {
            AssetException assetEx = this.rewrite(new AssetException("compiler", new AssetProblem(filename, -1, -1, ex.getMessage(), null), (Throwable)ex));
            this.errors.put(filename, assetEx);
        }
    }

    private AssetException rewrite(AssetException ex) {
        ArrayList stacktrace = Lists.newArrayList((Object[])ex.getStackTrace());
        List<AssetProblem> problems = ex.getProblems();
        AssetProblem head = problems.get(0);
        stacktrace.add(0, new StackTraceElement(head.getFilename(), "", head.getFilename(), head.getLine()));
        ex.setStackTrace(stacktrace.toArray(new StackTraceElement[stacktrace.size()]));
        return ex;
    }

    public void handle(Request req, Response rsp) throws Throwable {
        if (req.param("assets.sync").isSet()) {
            this.onChange(StandardWatchEventKinds.ENTRY_MODIFY, this.basedir);
        }
        if (this.errors.size() > 0) {
            throw this.errors.values().iterator().next();
        }
    }

    public void start() {
        this.watcher.start();
    }

    public void stop() throws Exception {
        this.watcher.stop();
    }
}

