/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooby.MediaType;
import org.jooby.assets.AssetProcessor;

public class Replace
extends AssetProcessor {
    @Override
    public boolean matches(MediaType type) {
        return true;
    }

    @Override
    public String process(String filename, String source, Config conf, ClassLoader loader) throws Exception {
        LinkedHashMap options = new LinkedHashMap();
        StringBuilder keys = new StringBuilder();
        this.options.withoutPath("excludes").entrySet().forEach(e -> {
            String key = ((String)e.getKey()).replace("\\\"", "");
            if (Character.isJavaIdentifierStart(key.charAt(0))) {
                keys.append("(\\b").append(key).append("\\b)");
            } else {
                keys.append("(").append(key).append(")");
            }
            options.put(key, ((ConfigValue)e.getValue()).unwrapped().toString());
            keys.append("|");
        });
        if (keys.length() > 0) {
            keys.setLength(keys.length() - 1);
            Pattern pattern = Pattern.compile(keys.toString());
            StringBuffer sb = new StringBuffer();
            Matcher matcher = pattern.matcher(source);
            while (matcher.find()) {
                String key = matcher.group();
                String value = (String)options.get(key);
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return source;
    }
}

