/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AssetWriter {
    private final String separator;
    private final Charset charset;
    private final String ext;
    private final Predicate<String> filter;
    private final Map<String, List<String>> fileset;
    private String fset;
    private File outDir;
    private StringBuilder bundle;
    private List<File> result;

    public AssetWriter(String dist, String fset, File outDir, String ext, String separator, Charset charset, Map<String, List<String>> fileset, Predicate<String> filter) {
        if (!dist.equals("dev")) {
            this.bundle = new StringBuilder();
            this.fset = fset;
        }
        this.outDir = outDir;
        this.separator = separator;
        this.result = new ArrayList<File>();
        this.charset = charset;
        this.ext = ext;
        this.fset = fset;
        this.filter = filter;
        this.fileset = fileset;
    }

    private Stream<String> patterns(Predicate<String> filter) {
        return this.fileset.values().stream().flatMap(Collection::stream).filter(filter).map(path -> path.split("/")[1]);
    }

    public void write(String path, String chunk) throws IOException {
        if (this.bundle == null) {
            File output = new File(this.outDir, path);
            this.writeFile(output, chunk);
            this.result.add(output);
        } else if (chunk.length() > 0) {
            this.bundle.append(chunk).append(this.separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getResult() throws IOException {
        try {
            if (this.bundle != null && this.bundle.length() > 0) {
                Path filename = Paths.get(this.fset + "." + this.sha1(this.bundle) + this.ext, new String[0]);
                Path filepath = this.patterns(this.filter).findFirst().map(p -> Paths.get(p, new String[0]).resolve(filename)).orElse(filename);
                File output = this.outDir.toPath().resolve(filepath).toFile();
                this.writeFile(output, this.bundle.toString());
                this.result.add(output);
            }
            List<File> list = this.result;
            return list;
        }
        finally {
            this.bundle = null;
        }
    }

    private String sha1(CharSequence source) {
        return BaseEncoding.base16().encode(Hashing.sha1().hashString(source, this.charset).asBytes()).substring(0, 8).toLowerCase();
    }

    private void writeFile(File output, String chunk) throws IOException {
        output.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(output, "UTF-8");){
            writer.write(chunk);
        }
    }

    public void add(String path) {
        if (this.bundle == null) {
            this.result.add(new File(this.outDir, path));
        }
    }
}

