/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.assets.AssetClassLoader;
import org.jooby.assets.AssetCompiler;
import org.jooby.handlers.AssetHandler;
import org.jooby.internal.assets.AssetVars;
import org.jooby.internal.assets.FileSystemAssetHandler;
import org.jooby.internal.assets.LiveCompiler;
import org.jooby.internal.assets.LiveProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assets
implements Jooby.Module {
    public void configure(Env env, Config config, Binder binder) throws Throwable {
        AssetHandler handler;
        boolean watch;
        String envname = env.name();
        boolean dev = "dev".equals(envname);
        ClassLoader loader = this.getClass().getClassLoader();
        Config conf = this.conf(dev, loader, config);
        String cpath = config.getString("application.path");
        ClassLoader assetClassLoader = AssetClassLoader.classLoader(loader);
        AssetCompiler compiler = new AssetCompiler(assetClassLoader, conf);
        Router routes = env.router();
        ImmutableList dist = dev ? ImmutableList.of((Object)"dev") : ImmutableList.of((Object)envname, (Object)"dist");
        String prefix = dist.stream().filter(it -> conf.hasPath("assets." + it + ".prefix")).findFirst().map(it -> conf.getString("assets." + it + ".prefix")).orElse(cpath);
        routes.use("*", "*", (Route.Handler)new AssetVars(compiler, prefix, !dev)).name("/assets/vars");
        boolean bl = watch = conf.hasPath("assets.watch") ? conf.getBoolean("assets.watch") : dev;
        if (watch) {
            Path publicDir = Paths.get(conf.getString("user.dir"), "public");
            Path workdir = Paths.get(conf.getString("assets.outputDir"), new String[0]);
            handler = new FileSystemAssetHandler("/", workdir, publicDir);
            LiveCompiler liveCompiler = new LiveCompiler(compiler, workdir);
            routes.use("*", "*", (Route.Handler)liveCompiler).name("/assets/compiler");
            int counter = Integer.parseInt(System.getProperty("joobyRun.counter", "0"));
            if (counter == 0) {
                long start = System.currentTimeMillis();
                LiveProgressBar progressBar = new LiveProgressBar();
                compiler.setProgressBar(progressBar);
                Future<Map<String, List<File>>> future = liveCompiler.sync();
                env.onStarted(() -> {
                    Logger log = LoggerFactory.getLogger(AssetCompiler.class);
                    if (!future.isDone()) {
                        progressBar.start();
                    }
                    Map result = (Map)future.get();
                    long end = System.currentTimeMillis();
                    log.info("{}", (Object)compiler.summary(result, workdir, "dev", end - start, new String[0]));
                    liveCompiler.watch();
                });
            } else {
                env.onStarted(liveCompiler::watch);
            }
            env.onStop(liveCompiler::stop);
        } else {
            handler = new AssetHandler("/");
        }
        handler.etag(conf.getBoolean("assets.etag")).cdn(conf.getString("assets.cdn")).lastModified(conf.getBoolean("assets.lastModified"));
        handler.maxAge(conf.getString("assets.cache.maxAge"));
        env.onStop(compiler::stop);
        compiler.patterns().forEach(pattern -> routes.get(pattern, (Route.Handler)handler));
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"assets.conf");
    }

    private Config conf(boolean dev, ClassLoader loader, Config conf) {
        if (!dev) {
            Config[] confs;
            for (Config it : confs = new Config[]{ConfigFactory.parseResources((ClassLoader)loader, (String)("assets." + conf.getString("application.env").toLowerCase() + ".conf")), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.dist.conf"), ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf")}) {
                if (it.isEmpty()) continue;
                return it.withFallback((ConfigMergeable)conf).resolve();
            }
        }
        return ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf").withFallback((ConfigMergeable)conf).resolve();
    }
}

