/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.assets;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.assets.AssetCompiler;
import org.jooby.assets.AssetException;
import org.jooby.assets.AssetProblem;
import org.jooby.funzy.Try;
import org.jooby.internal.assets.Watcher;

public class LiveCompiler
implements Route.Handler {
    private final AssetCompiler compiler;
    private final Map<String, AssetException> errors = new ConcurrentHashMap<String, AssetException>();
    private final Watcher watcher;
    private final Path workdir;
    private final ExecutorService executor;
    private final Path basedir;
    private final AtomicBoolean compilationDone;

    public LiveCompiler(AssetCompiler compiler, Path workdir) throws IOException {
        this.workdir = workdir;
        this.compiler = Objects.requireNonNull(compiler, "Asset compiler is required.");
        this.basedir = Paths.get("public", new String[0]);
        this.executor = Executors.newSingleThreadExecutor(task -> {
            Thread thread = new Thread(task, "asset-compiler");
            thread.setDaemon(true);
            return thread;
        });
        this.watcher = new Watcher(this.executor, this::onChange, this.basedir);
        this.compilationDone = new AtomicBoolean(false);
    }

    private void onChange(WatchEvent.Kind<?> kind, Path path) {
        File outputdir = this.workdir.toFile();
        String filename = Route.normalize((String)((String)Try.apply(() -> path.subpath(1, path.getNameCount()).toString()).orElse((Object)path.toString())));
        try {
            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                this.errors.remove(filename);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                this.errors.clear();
                this.compiler.build("dev", outputdir);
            } else {
                this.compiler.buildOne(filename, outputdir);
                this.errors.remove(filename);
            }
        }
        catch (AssetException ex) {
            String localname = ex.getProblems().stream().findFirst().map(AssetProblem::getFilename).orElse(filename);
            this.errors.put(localname, this.rewrite(ex));
        }
        catch (Exception ex) {
            AssetException assetEx = this.rewrite(new AssetException("compiler", new AssetProblem(filename, -1, -1, ex.getMessage(), null), (Throwable)ex));
            this.errors.put(filename, assetEx);
        }
    }

    private AssetException rewrite(AssetException ex) {
        ArrayList stacktrace = Lists.newArrayList((Object[])ex.getStackTrace());
        List<AssetProblem> problems = ex.getProblems();
        AssetProblem head = problems.get(0);
        stacktrace.add(0, new StackTraceElement(head.getFilename(), "", head.getFilename(), head.getLine()));
        ex.setStackTrace(stacktrace.toArray(new StackTraceElement[stacktrace.size()]));
        return ex;
    }

    public void handle(Request req, Response rsp) throws Throwable {
        if (this.compilationDone.get()) {
            if (req.param("assets.sync").isSet()) {
                this.onChange(StandardWatchEventKinds.ENTRY_MODIFY, this.basedir);
            }
            if (this.errors.size() > 0) {
                throw this.errors.values().iterator().next();
            }
        } else {
            rsp.type(MediaType.html).send((Object)"<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"UTF-8\">\n<meta http-equiv=\"refresh\" content=\"2\">\n<title>Compiling assets</title>\n</head>\n<body>\nCompiling assets, please wait...\n</body>\n</html>");
        }
    }

    public Future<Map<String, List<File>>> sync() {
        return this.executor.submit(() -> this.compiler.build("dev", this.workdir.toFile()));
    }

    public void watch() {
        this.compilationDone.set(true);
        this.watcher.start();
    }

    public void stop() throws Exception {
        this.executor.shutdown();
        this.watcher.stop();
    }
}

