/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jooby.Session;

@Singleton
public class CaffeineSessionStore
implements Session.Store {
    private Cache<String, Session> cache;

    @Inject
    public CaffeineSessionStore(@Named(value="session") Cache<String, Session> cache) {
        this.cache = Objects.requireNonNull(cache, "Session cache is required.");
    }

    public Session get(Session.Builder builder) {
        return (Session)this.cache.getIfPresent((Object)builder.sessionId());
    }

    public void save(Session session) {
        this.cache.put((Object)session.id(), (Object)session);
    }

    public void create(Session session) {
        this.cache.put((Object)session.id(), (Object)session);
    }

    public void delete(String id) {
        this.cache.invalidate((Object)id);
    }
}

