/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.caffeine;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Session;

public abstract class CaffeineCache<K, V>
implements Jooby.Module {
    private static final String DEF = "caffeine";
    private BiFunction<String, Caffeine, Object> callback = (n, b) -> b.build();
    private final String name;

    public CaffeineCache(String name) {
        this.name = name;
    }

    public CaffeineCache() {
        this(DEF);
    }

    public static CaffeineCache<String, Object> newCache() {
        return new CaffeineCache<String, Object>(){};
    }

    public CaffeineCache<K, V> doWith(Callback<K, V, Cache<K, V>> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        this.callback = configurer::apply;
        return this;
    }

    public CaffeineCache<K, V> doWithAsync(AsyncCallback<K, V> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        this.callback = configurer::apply;
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        Config gconf = conf.hasPath(this.name) ? conf : ConfigFactory.empty();
        gconf = gconf.withFallback((ConfigMergeable)ConfigFactory.empty().withValue("caffeine.cache", ConfigValueFactory.fromAnyRef((Object)"")));
        gconf.getObject(this.name).unwrapped().forEach((name, spec) -> {
            Caffeine cb = Caffeine.from((String)this.toSpec(spec));
            Object cache = this.callback.apply((String)name, cb);
            List<TypeLiteral> types = CaffeineCache.cacheType(name, cache, this.getClass().getGenericSuperclass());
            types.forEach(type -> {
                binder.bind(Key.get((TypeLiteral)type, (Annotation)Names.named((String)name))).toInstance(cache);
                if (name.equals("cache")) {
                    binder.bind(type).toInstance(cache);
                    binder.bind(type.getRawType()).toInstance(cache);
                }
                if (name.equals("session")) {
                    binder.bind(Key.get((TypeLiteral)type, (Annotation)Names.named((String)name))).toInstance(cache);
                    binder.bind(Key.get((Class)type.getRawType(), (Annotation)Names.named((String)name))).toInstance(cache);
                }
            });
        });
    }

    private static List<TypeLiteral> cacheType(String name, Object cache, Type superclass) {
        Class[] ctypes = cache instanceof AsyncLoadingCache ? new Class[]{AsyncLoadingCache.class} : (cache instanceof LoadingCache ? new Class[]{LoadingCache.class, Cache.class} : new Class[]{Cache.class});
        ArrayList<TypeLiteral> result = new ArrayList<TypeLiteral>(ctypes.length);
        for (Class ctype : ctypes) {
            if (name.equals("session")) {
                result.add(TypeLiteral.get((Type)Types.newParameterizedType((Type)ctype, (Type[])new Type[]{String.class, Session.class})));
                continue;
            }
            result.add(TypeLiteral.get((Type)Types.newParameterizedType((Type)ctype, (Type[])CaffeineCache.types(superclass))));
        }
        return result;
    }

    private String toSpec(Object spec) {
        if (spec instanceof Map) {
            Map m = (Map)spec;
            return m.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(","));
        }
        return spec.toString();
    }

    private static Type[] types(Type superclass) {
        Object key = String.class;
        Object value = Object.class;
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)superclass;
            Type[] args = parameterized.getActualTypeArguments();
            key = args[0];
            value = args[1];
        }
        return new Type[]{key, value};
    }

    public static interface AsyncCallback<K, V> {
        public AsyncLoadingCache<K, V> apply(String var1, Caffeine<K, V> var2);
    }

    public static interface Callback<K, V, C extends Cache<K, V>> {
        public C apply(String var1, Caffeine<K, V> var2);
    }
}

