/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.crash;

import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javaslang.concurrent.Future;
import javaslang.concurrent.Promise;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.WebSocket;
import org.jooby.crash.CrashBootstrap;
import org.jooby.crash.HttpShellPlugin;
import org.jooby.crash.WebShellPlugin;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Crash
implements Jooby.Module {
    private static final Key<Set<CRaSHPlugin>> PLUGINS;
    private final Set<Class> plugins = new HashSet<Class>();
    private final ClassLoader loader;

    public Crash(ClassLoader loader) {
        this.loader = Optional.ofNullable(loader).orElse(this.getClass().getClassLoader());
    }

    public Crash() {
        this(null);
    }

    public Crash plugin(Class<? extends CRaSHPlugin> plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        boolean webShell;
        Properties props = new Properties();
        if (conf.hasPath("crash")) {
            conf.getConfig("crash").entrySet().forEach(e -> props.setProperty("crash." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        }
        HashMap<String, Config> attributes = new HashMap<String, Config>();
        attributes.put("conf", conf);
        boolean bl = webShell = this.loader.getResource("META-INF/resources/js/crash.js") != null;
        if (webShell) {
            this.plugins.add(WebShellPlugin.class);
            WebShellPlugin.install(env, conf);
        }
        if (this.plugins.contains(HttpShellPlugin.class)) {
            HttpShellPlugin.install(env, conf);
        }
        Multibinder mb = Multibinder.newSetBinder((Binder)binder, CRaSHPlugin.class);
        this.plugins.forEach(it -> mb.addBinding().to(it));
        CrashBootstrap crash = new CrashBootstrap();
        Promise promise = Promise.make();
        binder.bind(PluginContext.class).toProvider(() -> ((Future)promise.future()).get());
        env.onStart(r -> {
            Set routes = (Set)r.require(Route.KEY);
            Set sockets = (Set)r.require(WebSocket.KEY);
            attributes.put("registry", (Config)r);
            attributes.put("routes", (Config)routes);
            attributes.put("websockets", (Config)sockets);
            attributes.put("env", (Config)env);
            HashSet plugins = Sets.newHashSet((Iterable)((Iterable)r.require(PLUGINS)));
            ServiceLoader.load(CRaSHPlugin.class, this.loader).forEach(plugins::add);
            promise.success((Object)crash.start(this.loader, props, attributes, plugins));
        });
        env.onStop(() -> ((CrashBootstrap)crash).stop());
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"crash.conf");
    }

    static {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        PLUGINS = Key.get((TypeLiteral)new TypeLiteral<Set<CRaSHPlugin>>(){});
    }
}

