/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.crash;

import java.util.function.Consumer;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.text.Screenable;
import org.crsh.text.Style;
import org.jooby.Result;
import org.jooby.Results;
import org.jooby.Status;

class SimpleProcessContext
implements ShellProcessContext {
    private final StringBuilder buff = new StringBuilder();
    private final Consumer<Result> deferred;
    private final int width;
    private final int height;

    public SimpleProcessContext(Consumer<Result> deferred) {
        this(deferred, 204, 48);
    }

    public SimpleProcessContext(Consumer<Result> deferred, int width, int height) {
        this.deferred = deferred;
        this.width = width;
        this.height = height;
    }

    public boolean takeAlternateBuffer() {
        return false;
    }

    public boolean releaseAlternateBuffer() {
        return false;
    }

    public String getProperty(String propertyName) {
        return null;
    }

    public String readLine(String msg, boolean echo) throws IllegalStateException {
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void flush() {
    }

    public Screenable append(Style style) {
        return this;
    }

    public Screenable cls() {
        return this;
    }

    public Appendable append(CharSequence csq) {
        this.buff.append(csq);
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) {
        this.buff.append(csq, start, end);
        return this;
    }

    public Appendable append(char c) {
        this.buff.append(c);
        return this;
    }

    public void end(ShellResponse response) {
        Status status = Status.SERVER_ERROR;
        if (response instanceof ShellResponse.Ok) {
            status = Status.OK;
        } else if (response instanceof ShellResponse.UnknownCommand) {
            status = Status.BAD_REQUEST;
        }
        this.deferred.accept(Results.with((Object)(this.buff.length() == 0 ? response.getMessage() : this.buff), (Status)status));
    }

    public String toString() {
        return this.buff.toString();
    }
}

