/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.crash;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.jooby.crash.CrashPredicate;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CrashFSDriver
extends AbstractFSDriver<Path>
implements AutoCloseable {
    private static final String LOGIN = "login.groovy";
    private static final Predicate<Path> FLOGIN = CrashFSDriver.fname("login.groovy");
    private static final String JAR = ".jar!";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Path root;
    private FileSystem fs;
    private Predicate<Path> filter;
    private final URI src;

    private CrashFSDriver(URI src, FileSystem fs, Predicate<Path> filter) {
        this.src = src;
        this.fs = fs;
        String path = src.toString();
        int jar = path.indexOf(JAR);
        path = path.substring(jar + JAR.length());
        this.root = fs.getPath(path, new String[0]);
        this.filter = filter;
    }

    private CrashFSDriver(URI src, Path root, Predicate<Path> filter) {
        this.src = src;
        this.root = root;
        this.filter = filter;
    }

    public Path root() {
        return this.root;
    }

    public String name(Path handle) {
        return Optional.ofNullable(handle.getFileName()).orElse(handle).toString().replaceAll("/", "");
    }

    public boolean isDir(Path handle) {
        return Files.isDirectory(handle, new LinkOption[0]);
    }

    public Iterable<Path> children(Path handle) throws IOException {
        try (Stream<Path> walk = Files.walk(handle, new FileVisitOption[0]);){
            Iterable iterable = walk.skip(1L).filter(this.filter).collect(Collectors.toList());
            return iterable;
        }
    }

    public boolean exists(Predicate<Path> filter) {
        try (Stream walk = (Stream)Try.apply(() -> Files.walk(this.root, new FileVisitOption[0])).orElse(Stream.empty());){
            boolean bl = walk.skip(1L).anyMatch(filter);
            return bl;
        }
    }

    public long getLastModified(Path handle) {
        return (Long)Try.apply(() -> Files.getLastModifiedTime(handle, new LinkOption[0]).toMillis()).orElse((Object)-1L);
    }

    public Iterator<InputStream> open(Path handle) throws IOException {
        return ImmutableList.of((Object)Files.newInputStream(handle, new OpenOption[0])).iterator();
    }

    @Override
    public void close() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    public String toString() {
        return this.root + " -> " + this.src;
    }

    public static List<CrashFSDriver> parse(ClassLoader loader, List<CrashPredicate> paths) {
        ArrayList<CrashFSDriver> drivers = new ArrayList<CrashFSDriver>();
        boolean loginFound = false;
        for (CrashPredicate path : paths) {
            for (URI uri : CrashFSDriver.expandPath(loader, path.name)) {
                CrashFSDriver driver = (CrashFSDriver)Try.apply(() -> FileSystems.newFileSystem(uri, Collections.emptyMap())).map(it -> (CrashFSDriver)Try.apply(() -> new CrashFSDriver(uri, (FileSystem)it, (Predicate<Path>)path)).get()).recover(x -> (CrashFSDriver)Try.apply(() -> new CrashFSDriver(uri, Paths.get(uri), (Predicate<Path>)path)).get()).get();
                driver.log.debug("driver created: {}", (Object)driver);
                if (loginFound) {
                    driver.filter = FLOGIN.negate().and(driver.filter);
                } else if (driver.exists(FLOGIN)) {
                    driver.log.debug("  login.groovy found: {}", (Object)driver);
                    loginFound = true;
                }
                drivers.add(driver);
            }
        }
        return drivers;
    }

    private static List<URI> expandPath(ClassLoader loader, String pattern) {
        ArrayList<URI> result = new ArrayList<URI>();
        File file = new File(pattern);
        if (file.exists()) {
            result.add(file.toURI());
        }
        Try.run(() -> Collections.list(loader.getResources(pattern)).stream().map(it -> (URI)Try.apply(it::toURI).get()).forEach(result::add));
        return result;
    }

    public static Predicate<Path> noneOf(String ... names) {
        Predicate<Path> predicate = CrashFSDriver.fname(names[0]);
        for (int i = 1; i < names.length; ++i) {
            predicate = predicate.or(CrashFSDriver.fname(names[i]));
        }
        return predicate.negate();
    }

    public static Predicate<Path> fname(String name) {
        return it -> Optional.ofNullable(it.getFileName()).map(Object::toString).orElse(it.toString()).equals(name);
    }

    public static Predicate<Path> endsWith(String ext) {
        return it -> Optional.ofNullable(it.getFileName()).map(Object::toString).orElse(it.toString()).endsWith(ext);
    }
}

