/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.crash;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.vfs.FS;
import org.crsh.vfs.spi.FSDriver;
import org.jooby.crash.CrashFSDriver;
import org.jooby.crash.CrashPredicate;
import org.jooby.funzy.Try;

class CrashBootstrap
extends PluginLifeCycle {
    private static final Predicate<Path> ACCEPT = CrashFSDriver.endsWith(".class").negate();
    private final List<CrashFSDriver> drivers = new ArrayList<CrashFSDriver>();

    CrashBootstrap() {
    }

    public PluginContext start(ClassLoader loader, Properties props, Map<String, Object> attributes, Set<CRaSHPlugin<?>> plugins) throws IOException {
        FS conffs = this.newFS(CrashFSDriver.parse(loader, Arrays.asList(new CrashPredicate("crash", ACCEPT))));
        FS cmdfs = this.newFS(CrashFSDriver.parse(loader, Arrays.asList(new CrashPredicate("cmd", ACCEPT), new CrashPredicate("org/jooby/crash", ACCEPT), new CrashPredicate("crash/commands", CrashFSDriver.noneOf("jndi.groovy", "jdbc.groovy", "jpa.groovy", "jul.groovy")))));
        this.setConfig(props);
        PluginContext ctx = new PluginContext(CrashBootstrap.executor("crash"), CrashBootstrap.scanner("crash-scanner"), () -> plugins, attributes, cmdfs, conffs, loader);
        ctx.refresh();
        this.start(ctx);
        return ctx;
    }

    public void shutdown() {
        this.drivers.forEach(it -> Try.run(it::close));
        super.stop();
    }

    private FS newFS(List<CrashFSDriver> drivers) throws IOException {
        FS fs = new FS();
        for (CrashFSDriver driver : drivers) {
            fs.mount((FSDriver)driver);
        }
        this.drivers.addAll(drivers);
        return fs;
    }

    private static ScheduledExecutorService scanner(String name) {
        return Executors.newScheduledThreadPool(1, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(name);
            return thread;
        });
    }

    private static ExecutorService executor(String name) {
        AtomicInteger next = new AtomicInteger(0);
        return new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(name + "-" + next.incrementAndGet());
            return thread;
        });
    }
}

