/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.crash;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.util.Utils;
import org.jooby.Request;
import org.jooby.WebSocket;
import org.jooby.crash.SimpleProcessContext;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebShellHandler
implements WebSocket.OnOpen {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    WebShellHandler() {
    }

    public void onOpen(Request req, WebSocket ws) throws Exception {
        PluginContext ctx = (PluginContext)req.require(PluginContext.class);
        ShellFactory factory = (ShellFactory)ctx.getPlugin(ShellFactory.class);
        Shell shell = factory.create(null);
        AtomicReference process = new AtomicReference();
        ws.onMessage(msg -> {
            String type;
            Map event = (Map)msg.to(Map.class);
            switch (type = (String)event.get("type")) {
                case "welcome": {
                    this.log.debug("sending welcome + prompt");
                    ws.send(this.event("print", shell.getWelcome()));
                    ws.send(this.event("prompt", shell.getPrompt()));
                    break;
                }
                case "execute": {
                    String command = (String)event.get("command");
                    Integer width = (Integer)event.get("width");
                    Integer height = (Integer)event.get("height");
                    process.set(shell.createProcess(command));
                    SimpleProcessContext context = new SimpleProcessContext(r -> {
                        Try.run(() -> {
                            process.set(null);
                            ws.send(this.event("print", r.get()));
                            ws.send(this.event("prompt", shell.getPrompt()));
                            ws.send(this.event("end"));
                        }).onFailure(x -> this.log.error("error found while sending output", x));
                        if ("bye".equals(command)) {
                            ws.close(WebSocket.NORMAL);
                        }
                    }, width, height);
                    this.log.debug("executing {}", (Object)command);
                    ((ShellProcess)process.get()).execute((ShellProcessContext)context);
                    break;
                }
                case "cancel": {
                    ShellProcess p = (ShellProcess)process.get();
                    if (p == null) break;
                    this.log.info("cancelling {}", (Object)p);
                    p.cancel();
                    break;
                }
                case "complete": {
                    String prefix = (String)event.get("prefix");
                    CompletionMatch completion = shell.complete(prefix);
                    Completion completions = completion.getValue();
                    Delimiter delimiter = completion.getDelimiter();
                    StringBuilder sb = new StringBuilder();
                    ArrayList<String> values = new ArrayList<String>();
                    if (completions.getSize() == 1) {
                        String value = (String)completions.getValues().iterator().next();
                        delimiter.escape((CharSequence)value, (Appendable)sb);
                        if (completions.get(value).booleanValue()) {
                            sb.append(delimiter.getValue());
                        }
                        values.add(sb.toString());
                    } else {
                        String commonCompletion = Utils.findLongestCommonPrefix((Iterable)completions.getValues());
                        if (commonCompletion.length() > 0) {
                            delimiter.escape((CharSequence)commonCompletion, (Appendable)sb);
                            values.add(sb.toString());
                        } else {
                            for (Map.Entry entry : completions) {
                                delimiter.escape((CharSequence)entry.getKey(), (Appendable)sb);
                                values.add(sb.toString());
                                sb.setLength(0);
                            }
                        }
                    }
                    this.log.debug("completing {} with {}", (Object)prefix, values);
                    ws.send(this.event("complete", values));
                }
            }
        });
        ws.onClose(status -> {
            this.log.info("closing web-socket");
            ShellProcess sp = (ShellProcess)process.get();
            if (sp != null) {
                sp.cancel();
            }
            shell.close();
        });
    }

    private Object event(String type, Object data) {
        return ImmutableMap.of((Object)"type", (Object)type, (Object)"data", (Object)data);
    }

    private Object event(String type) {
        return ImmutableMap.of((Object)"type", (Object)type);
    }
}

