/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ebean;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.stream.Collectors;
import org.avaje.agentloader.AgentLoader;
import org.jooby.internal.ebean.EbeanEnhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbeanAgentEnhancer
extends EbeanEnhancer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    EbeanAgentEnhancer(String transformerClass, String agentLoaderClass) {
        super(transformerClass, agentLoaderClass);
    }

    @Override
    public void run(Set<String> packages) {
        try {
            String params = "debug=0;packages=" + packages.stream().map(pkg -> pkg + ".**").collect(Collectors.joining(","));
            URL resource = this.getClass().getResource(this.transformerClass);
            String location = resource.getPath();
            int idx = location.indexOf(".jar!");
            if (idx > 0) {
                location = location.substring(0, idx + ".jar".length());
            }
            File jarLocation = location.startsWith("file:") ? new File(URI.create(location)) : new File(location);
            AgentLoader.loadAgent((String)jarLocation.getAbsolutePath(), (String)params);
        }
        catch (Exception ex) {
            this.log.trace("agent already loaded", (Throwable)ex);
        }
    }
}

