/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.ServerConfig;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.typesafe.config.Config;
import java.io.File;
import javax.inject.Provider;
import org.jooby.Managed;

public class EbeanManaged
implements Provider<EbeanServer>,
Managed {
    private Supplier<EbeanServer> ebean = Suppliers.memoize(() -> {
        EbeanServer ebean = EbeanServerFactory.create((ServerConfig)conf);
        if (conf.isDdlGenerate()) {
            String tmpdir = config.getString("application.tmpdir");
            this.move(conf.getName() + "-drop-all.sql", tmpdir);
            this.move(conf.getName() + "-create-all.sql", tmpdir);
        }
        return ebean;
    });

    public EbeanManaged(Config config, ServerConfig conf) {
    }

    private void move(String fname, String tmpdir) {
        new File(fname).renameTo(new File(tmpdir, fname));
    }

    public void start() throws Exception {
        this.ebean.get();
    }

    public void stop() throws Exception {
        if (this.ebean != null) {
            ((EbeanServer)this.ebean.get()).shutdown(false, false);
            this.ebean = null;
        }
    }

    public EbeanServer get() {
        return (EbeanServer)this.ebean.get();
    }
}

