/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.ServerConfig;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.internal.ebean.EbeanEnhancer;
import org.jooby.internal.ebean.EbeanManaged;
import org.jooby.internal.ebean.ForwardingDataSource;
import org.jooby.jdbc.Jdbc;

public class Ebeanby
extends Jdbc {
    private BiConsumer<ServerConfig, Config> configurer;
    private Set<String> packages = new HashSet<String>();

    public Ebeanby(String name) {
        super(name);
    }

    public Ebeanby() {
    }

    public Ebeanby packages(String ... packages) {
        Arrays.stream(packages).forEach(this.packages::add);
        return this;
    }

    public Ebeanby doWith(Consumer<ServerConfig> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this.doWith((ServerConfig config, Config conf) -> configurer.accept((ServerConfig)config));
    }

    public Ebeanby doWith(BiConsumer<ServerConfig, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        super.configure(env, conf, binder);
        ServerConfig config = new ServerConfig();
        this.packages.add(conf.getString("application.ns"));
        EbeanEnhancer.newEnhancer().run(this.packages);
        config.setName(this.dbName);
        this.packages.forEach(arg_0 -> ((ServerConfig)config).addPackage(arg_0));
        Config cprops = conf.getConfig("ebean");
        if (conf.hasPath("ebean." + this.dbName)) {
            cprops = conf.getConfig("ebean." + this.dbName).withFallback((ConfigMergeable)cprops);
        }
        Properties props = this.props(cprops);
        ContainerConfig container = new ContainerConfig();
        container.loadFromProperties(props);
        config.setContainerConfig(container);
        config.setDataSource((DataSource)new ForwardingDataSource((Provider<DataSource>)this.dataSource()));
        config.loadFromProperties(props);
        config.setDefaultServer(cprops.getBoolean("defaultServer"));
        config.setRegister(cprops.getBoolean("register"));
        if (this.configurer != null) {
            this.configurer.accept(config, conf);
        }
        EbeanManaged server = new EbeanManaged(conf, config);
        this.keys(EbeanServer.class, key -> binder.bind(key).toProvider(server).asEagerSingleton());
    }

    public Config config() {
        return ConfigFactory.parseResources(((Object)((Object)this)).getClass(), (String)"ebean.conf").withFallback((ConfigMergeable)super.config());
    }

    private Properties props(Config config) {
        Properties props = new Properties();
        config.entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            props.setProperty("ebean." + (String)prop.getKey(), value.toString());
        });
        return props;
    }
}

