/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.ServerConfig;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.internal.ebean.EbeanEnhancer;
import org.jooby.internal.ebean.EbeanManaged;
import org.jooby.jdbc.Jdbc;

public class Ebeanby
extends Jdbc {
    private Set<String> packages = new HashSet<String>();

    public Ebeanby(String name) {
        super(name);
    }

    public Ebeanby() {
    }

    public Ebeanby packages(String ... packages) {
        Arrays.stream(packages).forEach(this.packages::add);
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        this.configure(env, conf, binder, (name, ds) -> {
            ServerConfig config = new ServerConfig();
            this.packages.add(conf.getString("application.ns"));
            EbeanEnhancer.newEnhancer().run(this.packages);
            config.setName(name);
            this.packages.forEach(arg_0 -> ((ServerConfig)config).addPackage(arg_0));
            Config cprops = conf.getConfig("ebean");
            if (conf.hasPath("ebean." + name)) {
                cprops = conf.getConfig("ebean." + name).withFallback((ConfigMergeable)cprops).withoutPath(name);
            }
            Properties props = this.props(cprops);
            ContainerConfig container = new ContainerConfig();
            container.loadFromProperties(props);
            config.setContainerConfig(container);
            config.setDataSource((DataSource)ds);
            config.loadFromProperties(props);
            config.setDefaultServer(cprops.getBoolean("defaultServer"));
            config.setRegister(cprops.getBoolean("register"));
            this.callback(config, conf);
            EbeanManaged server = new EbeanManaged(conf, config);
            env.onStart(server::start);
            env.onStop(server::stop);
            env.serviceKey().generate(EbeanServer.class, name, k -> binder.bind(k).toProvider((Provider)server).asEagerSingleton());
        });
    }

    public Config config() {
        return ConfigFactory.parseResources(((Object)((Object)this)).getClass(), (String)"ebean.conf").withFallback((ConfigMergeable)super.config());
    }

    private Properties props(Config config) {
        Properties props = new Properties();
        config.entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            props.setProperty("ebean." + (String)prop.getKey(), value.toString());
        });
        return props;
    }
}

