/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.ebean;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import io.ebean.EbeanServer;
import io.ebean.config.ContainerConfig;
import io.ebean.config.ServerConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javaslang.control.Try;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.internal.ebean.EbeanEnhancer;
import org.jooby.internal.ebean.EbeanManaged;
import org.jooby.jdbc.Jdbc;

public class Ebeanby
extends Jdbc {
    static final AtomicReference<Set<String>> PKG = new AtomicReference(new HashSet());

    public Ebeanby(String name) {
        super(name);
    }

    public Ebeanby() {
    }

    public void configure(Env env, Config conf, Binder binder) {
        this.configure(env, conf, binder, (name, ds) -> {
            ServerConfig config = new ServerConfig();
            config.setName(name);
            Config cprops = conf.getConfig("ebean");
            if (conf.hasPath("ebean." + name)) {
                cprops = conf.getConfig("ebean." + name).withFallback((ConfigMergeable)cprops).withoutPath(name);
            }
            Properties props = this.props(cprops);
            ContainerConfig container = new ContainerConfig();
            container.loadFromProperties(props);
            config.setContainerConfig(container);
            config.setDataSource((DataSource)ds);
            config.loadFromProperties(props);
            config.setDefaultServer(cprops.getBoolean("defaultServer"));
            config.setRegister(cprops.getBoolean("register"));
            this.callback(config, conf);
            List packages = config.getPackages();
            if (packages == null || packages.size() == 0) {
                packages = ImmutableList.of((Object)conf.getString("application.ns"));
            }
            config.setPackages(packages);
            PKG.get().addAll(packages);
            EbeanManaged server = new EbeanManaged(conf, config);
            env.onStart(server::start);
            env.onStop(server::stop);
            Consumer<Key> provider = k -> binder.bind(k).toProvider((Provider)server).asEagerSingleton();
            Env.ServiceKey keys = env.serviceKey();
            if (!name.equals(this.dbref)) {
                keys.generate(EbeanServer.class, this.dbref, provider);
            }
            keys.generate(EbeanServer.class, name, provider);
        });
        env.onStart(Ebeanby.runEnhancer());
    }

    public Config config() {
        return ConfigFactory.parseResources(((Object)((Object)this)).getClass(), (String)"ebean.conf").withFallback((ConfigMergeable)super.config());
    }

    private Properties props(Config config) {
        Properties props = new Properties();
        config.entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            props.setProperty("ebean." + (String)prop.getKey(), value.toString());
        });
        return props;
    }

    static Try.CheckedRunnable runEnhancer() {
        return () -> {
            Set packages = PKG.getAndSet(null);
            if (packages != null) {
                EbeanEnhancer.newEnhancer().run(packages);
            }
        };
    }

    static {
        System.setProperty("ebean.registerShutdownHook", "false");
    }
}

