/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.ebean;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import io.ebean.EbeanServer;
import io.ebean.config.ContainerConfig;
import io.ebean.config.ServerConfig;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.funzy.Throwing;
import org.jooby.internal.ebean.EbeanEnhancer;
import org.jooby.internal.ebean.EbeanManaged;

public class Ebeanby
implements Jooby.Module {
    static final AtomicReference<Set<String>> PKG = new AtomicReference(new HashSet());
    private String name;
    private BiConsumer<ServerConfig, Config> callback;

    public Ebeanby(String name) {
        this.name = name;
    }

    public Ebeanby() {
        this("db");
    }

    public void configure(Env env, Config conf, Binder binder) {
        List packages;
        ServerConfig config = new ServerConfig();
        config.setName(this.name);
        Config cprops = conf.getConfig("ebean");
        if (conf.hasPath("ebean." + this.name)) {
            cprops = conf.getConfig("ebean." + this.name).withFallback((ConfigMergeable)cprops).withoutPath(this.name);
        }
        Properties props = this.props(cprops);
        ContainerConfig container = new ContainerConfig();
        container.loadFromProperties(props);
        Key dskey = Key.get(DataSource.class, (Annotation)Names.named((String)this.name));
        DataSource ds = (DataSource)env.get(dskey).orElseThrow(() -> new NoSuchElementException("DataSource missing: " + dskey));
        config.setDataSource(ds);
        config.setContainerConfig(container);
        config.loadFromProperties(props);
        config.setDefaultServer(cprops.getBoolean("defaultServer"));
        config.setRegister(cprops.getBoolean("register"));
        if (this.callback != null) {
            this.callback.accept(config, conf);
        }
        if ((packages = config.getPackages()) == null || packages.size() == 0) {
            packages = ImmutableList.of((Object)conf.getString("application.ns"));
        }
        config.setPackages(packages);
        if (PKG.get() != null) {
            PKG.get().addAll(packages);
        }
        EbeanManaged ebean = new EbeanManaged(conf, config);
        env.onStart(ebean::start);
        env.onStop(ebean::stop);
        Consumer<Key> provider = k -> binder.bind(k).toProvider((Provider)ebean);
        Env.ServiceKey keys = env.serviceKey();
        keys.generate(EbeanServer.class, this.name, provider);
        env.onStart(Ebeanby.runEnhancer());
    }

    public Ebeanby doWith(BiConsumer<ServerConfig, Config> configurer) {
        this.callback = Objects.requireNonNull(configurer, "Configurer required.");
        return this;
    }

    public Ebeanby doWith(Consumer<ServerConfig> configurer) {
        Objects.requireNonNull(configurer, "Configurer required.");
        return this.doWith((ServerConfig server, Config conf) -> configurer.accept((ServerConfig)server));
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"ebean.conf");
    }

    private Properties props(Config config) {
        Properties props = new Properties();
        config.entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            props.setProperty("ebean." + (String)prop.getKey(), value.toString());
        });
        return props;
    }

    static Throwing.Runnable runEnhancer() {
        return () -> {
            Set packages = PKG.getAndSet(null);
            if (packages != null) {
                EbeanEnhancer.newEnhancer().run(packages);
            }
        };
    }

    static {
        System.setProperty("ebean.registerShutdownHook", "false");
    }
}

