/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.ehcache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.jooby.Session;

public class EhSessionStore
implements Session.Store {
    private Ehcache cache;

    @Inject
    public EhSessionStore(@Named(value="session") Ehcache cache) {
        this.cache = Objects.requireNonNull(cache, "Sessions cache is required.");
    }

    public Session get(Session.Builder builder) {
        String sessionId = builder.sessionId();
        Element element = this.cache.get((Serializable)((Object)sessionId));
        if (element == null) {
            return null;
        }
        HashMap attrs = new HashMap((Map)element.getObjectValue());
        return builder.accessedAt(Long.parseLong((String)attrs.remove("_accessedAt"))).createdAt(Long.parseLong((String)attrs.remove("_createdAt"))).savedAt(Long.parseLong((String)attrs.remove("_savedAt"))).set(attrs).build();
    }

    public void save(Session session) {
        HashMap<String, String> attributes = new HashMap<String, String>(session.attributes());
        attributes.put("_accessedAt", Long.toString(session.accessedAt()));
        attributes.put("_createdAt", Long.toString(session.createdAt()));
        attributes.put("_savedAt", Long.toString(session.savedAt()));
        this.cache.put(new Element((Object)session.id(), attributes));
    }

    public void create(Session session) {
        this.save(session);
    }

    public void delete(String id) {
        this.cache.remove((Serializable)((Object)id));
    }
}

