/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ehcache;

import com.typesafe.config.Config;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import org.jooby.internal.ehcache.EhCacheBuilder;

public class ConfigurationBuilder
extends EhCacheBuilder {
    private Configuration eh = new Configuration();

    public Configuration build(Config config) {
        this.sint("ehcache", config, "defaultTransactionTimeoutInSeconds", arg_0 -> ((Configuration)this.eh).setDefaultTransactionTimeoutInSeconds(arg_0));
        this.siseconds("ehcache", config, "defaultTransactionTimeout", arg_0 -> ((Configuration)this.eh).setDefaultTransactionTimeoutInSeconds(arg_0));
        this.sbool("ehcache", config, "dynamicConfig", arg_0 -> ((Configuration)this.eh).setDynamicConfig(arg_0));
        this.sbytes("ehcache", config, "maxBytesLocalDisk", arg_0 -> ((Configuration)this.eh).setMaxBytesLocalDisk(arg_0));
        this.sbytes("ehcache", config, "maxBytesLocalHeap", arg_0 -> ((Configuration)this.eh).setMaxBytesLocalHeap(arg_0));
        this.sbytes("ehcache", config, "maxBytesLocalOffHeap", arg_0 -> ((Configuration)this.eh).setMaxBytesLocalOffHeap(arg_0));
        this.sstr("ehcache", config, "monitoring", arg_0 -> ((Configuration)this.eh).setMonitoring(arg_0));
        this.sstr("ehcache", config, "name", arg_0 -> ((Configuration)this.eh).setName(arg_0));
        this.eh.setUpdateCheck(false);
        this.sconf("ehcache", config, "cacheManagerEventListenerFactory", this::cacheManagerEventListenerFactory);
        this.sconf("ehcache", config, "cacheManagerPeerListenerFactory", this::cacheManagerPeerListenerFactory);
        this.sconf("ehcache", config, "cacheManagerPeerProviderFactory", this::cacheManagerPeerProviderFactory);
        this.sconf("ehcache", config, "diskStore", this::diskStore);
        this.sconf("ehcache", config, "sizeOfPolicy", this::sizeOfPolicy);
        this.sconf("ehcache", config, "terracottaConfig", this::terracotaConfig);
        this.sconf("ehcache", config, "transactionManagerLookup", this::transactionManagerLookup);
        return this.eh;
    }

    private void cacheManagerEventListenerFactory(Config conf) {
        this.eh.addCacheManagerEventListenerFactory(this.newFactory("ehcache.cacheManagerEventListenerFactory", conf, FactoryConfiguration::new));
    }

    private void cacheManagerPeerListenerFactory(Config conf) {
        if (conf.hasPath("class")) {
            this.eh.addCacheManagerPeerListenerFactory(this.newFactory("ehcache.cacheManagerPeerListenerFactory", conf, FactoryConfiguration::new));
        } else {
            this.each(conf, (name, c) -> this.eh.addCacheManagerPeerListenerFactory(this.newFactory("ehcache.cacheManagerPeerListenerFactory." + name, (Config)c, FactoryConfiguration::new)));
        }
    }

    private void cacheManagerPeerProviderFactory(Config conf) {
        if (conf.hasPath("class")) {
            this.eh.addCacheManagerPeerProviderFactory(this.newFactory("ehcache.cacheManagerPeerProviderFactory", conf, FactoryConfiguration::new));
        } else {
            this.each(conf, (name, c) -> this.eh.addCacheManagerPeerProviderFactory(this.newFactory("ehcache.cacheManagerPeerProviderFactory." + name, (Config)c, FactoryConfiguration::new)));
        }
    }

    private void diskStore(Config conf) {
        DiskStoreConfiguration diskStore = new DiskStoreConfiguration();
        diskStore.setPath(conf.getString("path"));
        this.eh.addDiskStore(diskStore);
    }

    private void sizeOfPolicy(Config conf) {
        SizeOfPolicyConfiguration sizeOfPolicy = this.sizeOfPolicy("ehcache.sizeOfPolicy", conf);
        this.eh.addSizeOfPolicy(sizeOfPolicy);
    }

    private void terracotaConfig(Config config) {
        TerracottaClientConfiguration terracota = new TerracottaClientConfiguration();
        this.sbool("ehcache.terracottaConfig", config, "rejoin", arg_0 -> ((TerracottaClientConfiguration)terracota).setRejoin(arg_0));
        this.sstr("ehcache.terracottaConfig", config, "url", arg_0 -> ((TerracottaClientConfiguration)terracota).setUrl(arg_0));
        this.sbool("ehcache.terracottaConfig", config, "wanEnabledTSA", arg_0 -> ((TerracottaClientConfiguration)terracota).setWanEnabledTSA(arg_0));
        this.eh.addTerracottaConfig(terracota);
    }

    private void transactionManagerLookup(Config conf) {
        this.eh.addTransactionManagerLookup(this.newFactory("ehcache.transactionManagerLookup", conf, FactoryConfiguration::new));
    }
}

