/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ehcache;

import com.typesafe.config.Config;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import org.jooby.internal.ehcache.EhCacheBuilder;

public class CacheConfigurationBuilder
extends EhCacheBuilder {
    private String path;
    private CacheConfiguration cache;

    public CacheConfigurationBuilder(String name) {
        this.path = "ehcache.cache." + name;
        this.cache = new CacheConfiguration();
        this.cache.setName(name);
    }

    public CacheConfiguration build(Config config) {
        this.sms(this.path, config, "cacheLoaderTimeout", arg_0 -> ((CacheConfiguration)this.cache).setCacheLoaderTimeoutMillis(arg_0));
        this.slong(this.path, config, "cacheLoaderTimeoutMillis", arg_0 -> ((CacheConfiguration)this.cache).setCacheLoaderTimeoutMillis(arg_0));
        this.sbool(this.path, config, "clearOnFlush", arg_0 -> ((CacheConfiguration)this.cache).setClearOnFlush(arg_0));
        this.sbool(this.path, config, "copyOnRead", arg_0 -> ((CacheConfiguration)this.cache).setCopyOnRead(arg_0));
        this.sbool(this.path, config, "copyOnWrite", arg_0 -> ((CacheConfiguration)this.cache).setCopyOnWrite(arg_0));
        this.sint(this.path, config, "diskAccessStripes", arg_0 -> ((CacheConfiguration)this.cache).setDiskAccessStripes(arg_0));
        this.sseconds(this.path, config, "diskExpiryThreadInterval", arg_0 -> ((CacheConfiguration)this.cache).setDiskExpiryThreadIntervalSeconds(arg_0));
        this.slong(this.path, config, "diskExpiryThreadIntervalSeconds", arg_0 -> ((CacheConfiguration)this.cache).setDiskExpiryThreadIntervalSeconds(arg_0));
        this.sint(this.path, config, "diskSpoolBufferSizeMB", arg_0 -> ((CacheConfiguration)this.cache).setDiskSpoolBufferSizeMB(arg_0));
        this.sbool(this.path, config, "eternal", arg_0 -> ((CacheConfiguration)this.cache).setEternal(arg_0));
        this.sbool(this.path, config, "logging", arg_0 -> ((CacheConfiguration)this.cache).setLogging(arg_0));
        this.sbytes(this.path, config, "maxBytesLocalDisk", arg_0 -> ((CacheConfiguration)this.cache).setMaxBytesLocalDisk(arg_0));
        this.sbytes(this.path, config, "maxBytesLocalHeap", arg_0 -> ((CacheConfiguration)this.cache).setMaxBytesLocalHeap(arg_0));
        this.sbytes(this.path, config, "maxBytesLocalOffHeap", arg_0 -> ((CacheConfiguration)this.cache).setMaxBytesLocalOffHeap(arg_0));
        this.slong(this.path, config, "maxElementsInMemory", arg_0 -> ((CacheConfiguration)this.cache).setMaxEntriesLocalHeap(arg_0));
        this.slong(this.path, config, "maxElementsOnDisk", arg_0 -> ((CacheConfiguration)this.cache).setMaxEntriesLocalDisk(arg_0));
        this.slong(this.path, config, "maxEntriesInCache", arg_0 -> ((CacheConfiguration)this.cache).setMaxEntriesInCache(arg_0));
        this.slong(this.path, config, "maxEntriesLocalDisk", arg_0 -> ((CacheConfiguration)this.cache).setMaxEntriesLocalDisk(arg_0));
        this.slong(this.path, config, "maxEntriesLocalHeap", arg_0 -> ((CacheConfiguration)this.cache).setMaxEntriesLocalHeap(arg_0));
        this.sbytes(this.path, config, "maxMemoryOffHeap", arg_0 -> ((CacheConfiguration)this.cache).setMaxBytesLocalOffHeap(arg_0));
        this.sstr(this.path, config, "memoryStoreEvictionPolicy", arg_0 -> ((CacheConfiguration)this.cache).setMemoryStoreEvictionPolicy(arg_0));
        this.sbool(this.path, config, "overflowToOffHeap", arg_0 -> ((CacheConfiguration)this.cache).setOverflowToOffHeap(arg_0));
        this.sseconds(this.path, config, "timeToIdle", arg_0 -> ((CacheConfiguration)this.cache).setTimeToIdleSeconds(arg_0));
        this.slong(this.path, config, "timeToIdleSeconds", arg_0 -> ((CacheConfiguration)this.cache).setTimeToIdleSeconds(arg_0));
        this.sseconds(this.path, config, "timeToLive", arg_0 -> ((CacheConfiguration)this.cache).setTimeToLiveSeconds(arg_0));
        this.slong(this.path, config, "timeToLiveSeconds", arg_0 -> ((CacheConfiguration)this.cache).setTimeToLiveSeconds(arg_0));
        this.sstr(this.path, config, "transactionalMode", arg_0 -> ((CacheConfiguration)this.cache).setTransactionalMode(arg_0));
        this.sconf(this.path, config, "persistence", this::persistence);
        this.sconf(this.path, config, "bootstrapCacheLoaderFactory", this::bootstrapCacheLoaderFactory);
        this.sconf(this.path, config, "cacheDecoratorFactory", this::cacheDecoratorFactory);
        this.sconf(this.path, config, "cacheEventListenerFactory", this::cacheEventListenerFactory);
        this.sconf(this.path, config, "cacheExceptionHandlerFactory", this::cacheExceptionHandlerFactory);
        this.sconf(this.path, config, "cacheExtensionFactory", this::cacheExtensionFactory);
        this.sconf(this.path, config, "cacheLoaderFactory", this::cacheLoaderFactory);
        this.sconf(this.path, config, "cacheWriter", this::cacheWriter);
        this.sstr(this.path, config, "pinning.store", pinning -> this.cache.addPinning(new PinningConfiguration().store(pinning)));
        this.sconf(this.path, config, "sizeOfPolicy", this::sizeOfPolicy);
        this.sconf(this.path, config, "terracotta", this::terracota);
        return this.cache;
    }

    private void cacheLoaderFactory(Config conf) {
        if (conf.hasPath("class")) {
            this.cache.addCacheLoaderFactory(this.newFactory(this.path + ".cacheLoaderFactory", conf, CacheConfiguration.CacheLoaderFactoryConfiguration::new));
        } else {
            this.each(conf, (name, c) -> this.cache.addCacheLoaderFactory(this.newFactory(this.path + ".cacheLoaderFactory." + name, (Config)c, CacheConfiguration.CacheLoaderFactoryConfiguration::new)));
        }
    }

    private void persistence(Config conf) {
        PersistenceConfiguration persistence = new PersistenceConfiguration();
        this.sstr(this.path + ".persistence", conf, "strategy", arg_0 -> ((PersistenceConfiguration)persistence).setStrategy(arg_0));
        this.sbool(this.path + ".persistence", conf, "synchronousWrites", arg_0 -> ((PersistenceConfiguration)persistence).setSynchronousWrites(arg_0));
        this.cache.addPersistence(persistence);
    }

    private void bootstrapCacheLoaderFactory(Config conf) {
        this.cache.addBootstrapCacheLoaderFactory(this.newFactory(this.path + ".bootstrapCacheLoaderFactory", conf, CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration::new));
    }

    private void cacheDecoratorFactory(Config conf) {
        if (conf.hasPath("class")) {
            this.cache.addCacheDecoratorFactory(this.newFactory(this.path + ".cacheDecoratorFactory", conf, CacheConfiguration.CacheDecoratorFactoryConfiguration::new));
        } else {
            this.each(conf, (name, decoconf) -> this.cache.addCacheDecoratorFactory(this.newFactory(this.path + ".cacheDecoratorFactory." + name, (Config)decoconf, CacheConfiguration.CacheDecoratorFactoryConfiguration::new)));
        }
    }

    private void sizeOfPolicy(Config conf) {
        this.cache.addSizeOfPolicy(this.sizeOfPolicy(this.path + ".sizeOfPolicy", conf));
    }

    private void cacheExtensionFactory(Config conf) {
        if (conf.hasPath("class")) {
            this.cache.addCacheExtensionFactory(this.newFactory(this.path + ".cacheExtensionFactory", conf, CacheConfiguration.CacheExtensionFactoryConfiguration::new));
        } else {
            this.each(conf, (name, decoconf) -> this.cache.addCacheExtensionFactory(this.newFactory(this.path + ".cacheExtensionFactory." + name, (Config)decoconf, CacheConfiguration.CacheExtensionFactoryConfiguration::new)));
        }
    }

    private void cacheEventListenerFactory(Config conf) {
        if (conf.hasPath("class")) {
            this.cache.addCacheEventListenerFactory(this.newCacheEventListenerFactory(this.path + ".cacheEventListenerFactory", conf));
        } else {
            this.each(conf, (name, c) -> this.cache.addCacheEventListenerFactory(this.newCacheEventListenerFactory(this.path + ".cacheEventListenerFactory" + name, (Config)c)));
        }
    }

    private void cacheExceptionHandlerFactory(Config conf) {
        this.cache.addCacheExceptionHandlerFactory(this.newFactory(this.path + ".cacheExceptionHandlerFactory", conf, CacheConfiguration.CacheExceptionHandlerFactoryConfiguration::new));
    }

    private void cacheWriter(Config conf) {
        String path = this.path + ".cacheWriter";
        CacheWriterConfiguration writer = new CacheWriterConfiguration();
        this.sint(path, conf, "maxWriteDelay", arg_0 -> ((CacheWriterConfiguration)writer).setMaxWriteDelay(arg_0));
        this.sint(path, conf, "minWriteDelay", arg_0 -> ((CacheWriterConfiguration)writer).setMinWriteDelay(arg_0));
        this.sbool(path, conf, "notifyListenersOnException", arg_0 -> ((CacheWriterConfiguration)writer).setNotifyListenersOnException(arg_0));
        this.sint(path, conf, "rateLimitPerSecond", arg_0 -> ((CacheWriterConfiguration)writer).setRateLimitPerSecond(arg_0));
        this.siseconds(path, conf, "retryAttemptDelay", arg_0 -> ((CacheWriterConfiguration)writer).setRetryAttemptDelaySeconds(arg_0));
        this.sint(path, conf, "retryAttemptDelaySeconds", arg_0 -> ((CacheWriterConfiguration)writer).setRetryAttemptDelaySeconds(arg_0));
        this.sint(path, conf, "retryAttempts", arg_0 -> ((CacheWriterConfiguration)writer).setRetryAttempts(arg_0));
        this.sbool(path, conf, "writeBatching", arg_0 -> ((CacheWriterConfiguration)writer).setWriteBatching(arg_0));
        this.sint(path, conf, "writeBatchSize", arg_0 -> ((CacheWriterConfiguration)writer).setWriteBatchSize(arg_0));
        this.sint(path, conf, "writeBehindConcurrency", arg_0 -> ((CacheWriterConfiguration)writer).setWriteBehindConcurrency(arg_0));
        this.sint(path, conf, "writeBehindMaxQueueSize", arg_0 -> ((CacheWriterConfiguration)writer).setWriteBehindMaxQueueSize(arg_0));
        this.sbool(path, conf, "writeCoalescing", arg_0 -> ((CacheWriterConfiguration)writer).setWriteCoalescing(arg_0));
        this.sstr(path, conf, "writeMode", arg_0 -> ((CacheWriterConfiguration)writer).setWriteMode(arg_0));
        this.cache.addCacheWriter(writer);
    }

    private void terracota(Config config) {
        TerracottaConfiguration terracota = new TerracottaConfiguration();
        String path = this.path + ".terracotta";
        this.sconf(path, config, "nonstop", conf -> terracota.addNonstop(this.nonstop(path + ".nonstop", (Config)conf)));
        this.sbool(path, config, "cacheXA", arg_0 -> ((TerracottaConfiguration)terracota).setCacheXA(arg_0));
        this.sbool(path, config, "clustered", arg_0 -> ((TerracottaConfiguration)terracota).setClustered(arg_0));
        this.sbool(path, config, "coherent", coherent -> terracota.setConsistency(coherent != false ? TerracottaConfiguration.Consistency.STRONG : TerracottaConfiguration.Consistency.EVENTUAL));
        this.sbool(path, config, "compressionEnabled", arg_0 -> ((TerracottaConfiguration)terracota).setCompressionEnabled(arg_0));
        this.sint(path, config, "concurrency", arg_0 -> ((TerracottaConfiguration)terracota).setConcurrency(arg_0));
        this.sstr(path, config, "consistency", arg_0 -> ((TerracottaConfiguration)terracota).setConsistency(arg_0));
        this.sbool(path, config, "localCacheEnabled", arg_0 -> ((TerracottaConfiguration)terracota).setLocalCacheEnabled(arg_0));
        this.sbool(path, config, "localKeyCache", arg_0 -> ((TerracottaConfiguration)terracota).setLocalKeyCache(arg_0));
        this.sint(path, config, "localKeyCacheSize", arg_0 -> ((TerracottaConfiguration)terracota).setLocalKeyCacheSize(arg_0));
        this.sbool(path, config, "orphanEviction", arg_0 -> ((TerracottaConfiguration)terracota).setOrphanEviction(arg_0));
        this.sint(path, config, "orphanEvictionPeriod", arg_0 -> ((TerracottaConfiguration)terracota).setOrphanEvictionPeriod(arg_0));
        this.sbool(path, config, "synchronousWrites", arg_0 -> ((TerracottaConfiguration)terracota).setSynchronousWrites(arg_0));
        this.cache.addTerracotta(terracota);
    }

    private NonstopConfiguration nonstop(String path, Config config) {
        NonstopConfiguration nonstop = new NonstopConfiguration();
        this.sconf(path, config, "timeout", conf -> nonstop.addTimeoutBehavior(this.timeout((Config)conf)));
        this.sms(path, config, "searchTimeoutMillis", arg_0 -> ((NonstopConfiguration)nonstop).searchTimeoutMillis(arg_0));
        this.sint(path, config, "bulkOpsTimeoutMultiplyFactor", arg_0 -> ((NonstopConfiguration)nonstop).setBulkOpsTimeoutMultiplyFactor(arg_0));
        this.sbool(path, config, "enabled", arg_0 -> ((NonstopConfiguration)nonstop).setEnabled(arg_0));
        this.sbool(path, config, "immediateTimeout", arg_0 -> ((NonstopConfiguration)nonstop).setImmediateTimeout(arg_0));
        this.sms(path, config, "timeoutMillis", arg_0 -> ((NonstopConfiguration)nonstop).searchTimeoutMillis(arg_0));
        return nonstop;
    }

    private TimeoutBehaviorConfiguration timeout(Config config) {
        TimeoutBehaviorConfiguration timeout = new TimeoutBehaviorConfiguration();
        String sep = ";";
        timeout.setProperties(this.toPropertiesLine(config.withoutPath("type"), sep));
        timeout.setPropertySeparator(sep);
        timeout.setType(config.getString("type"));
        return timeout;
    }

    private CacheConfiguration.CacheEventListenerFactoryConfiguration newCacheEventListenerFactory(String path, Config config) {
        CacheConfiguration.CacheEventListenerFactoryConfiguration factory = this.newFactory(path, config.withoutPath("listenFor"), CacheConfiguration.CacheEventListenerFactoryConfiguration::new);
        this.sstr(path, config, "listenFor", arg_0 -> ((CacheConfiguration.CacheEventListenerFactoryConfiguration)factory).listenFor(arg_0));
        return factory;
    }
}

