/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.ehcache;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.Configuration;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.internal.ehcache.CacheConfigurationBuilder;
import org.jooby.internal.ehcache.ConfigurationBuilder;

public class Eh
implements Jooby.Module {
    private BiConsumer<Configuration, Config> configurer;

    public void configure(Env env, Config config, Binder binder) {
        Config ehcache = config.getConfig("ehcache");
        Config caches = ehcache.getConfig("cache");
        Config defcache = caches.getConfig("default");
        Configuration ehconfig = new ConfigurationBuilder().build(ehcache);
        ehconfig.setDefaultCacheConfiguration(new CacheConfigurationBuilder("default").build(defcache));
        Config userCaches = caches.withoutPath("default");
        for (Map.Entry userCache : userCaches.root().entrySet()) {
            ConfigValue value = (ConfigValue)userCache.getValue();
            String cname = (String)userCache.getKey();
            Config ccache = ConfigFactory.empty();
            if (value instanceof ConfigObject) {
                ccache = ((ConfigObject)value).toConfig();
            }
            ehconfig.addCache(new CacheConfigurationBuilder(cname).build(ccache.withFallback((ConfigMergeable)defcache)));
        }
        if (this.configurer != null) {
            this.configurer.accept(ehconfig, config);
        }
        CacheManager cm = CacheManager.newInstance((Configuration)ehconfig);
        binder.bind(CacheManager.class).toInstance((Object)cm);
        env.onStop(() -> ((CacheManager)cm).shutdown());
        String[] names = cm.getCacheNames();
        if (names.length == 1) {
            binder.bind(Ehcache.class).toInstance((Object)cm.getEhcache(names[0]));
        }
        for (String name : cm.getCacheNames()) {
            binder.bind(Ehcache.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)cm.getEhcache(name));
        }
    }

    public Eh doWith(BiConsumer<Configuration, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this;
    }

    public Eh doWith(Consumer<Configuration> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this.doWith((Configuration ehconf, Config conf) -> configurer.accept((Configuration)ehconf));
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"ehcache.conf");
    }
}

