/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ehcache;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigUtil;
import com.typesafe.config.ConfigValue;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import org.jooby.ehcache.Eh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EhCacheBuilder {
    private final Logger log = LoggerFactory.getLogger(Eh.class);

    EhCacheBuilder() {
    }

    protected SizeOfPolicyConfiguration sizeOfPolicy(String path, Config conf) {
        SizeOfPolicyConfiguration sizeOfPolicy = new SizeOfPolicyConfiguration();
        this.sint(path, conf, "maxDepth", arg_0 -> ((SizeOfPolicyConfiguration)sizeOfPolicy).maxDepth(arg_0));
        this.sstr(path, conf, "maxDepthExceededBehavior", arg_0 -> ((SizeOfPolicyConfiguration)sizeOfPolicy).maxDepthExceededBehavior(arg_0));
        return sizeOfPolicy;
    }

    protected <T extends FactoryConfiguration<?>> T newFactory(String path, Config config, Supplier<T> supplier) {
        FactoryConfiguration factory = (FactoryConfiguration)supplier.get();
        this.sstr(path, config, "class", arg_0 -> ((FactoryConfiguration)factory).setClass(arg_0));
        String sep = ";";
        factory.setProperties(this.toPropertiesLine(config.withoutPath("class"), sep));
        factory.setPropertySeparator(";");
        Objects.requireNonNull(factory.getFullyQualifiedClassPath(), "No .class found in: " + path);
        return (T)factory;
    }

    protected String toPropertiesLine(Config properties, String sep) {
        StringBuilder plainprops = new StringBuilder();
        for (Map.Entry property : properties.entrySet()) {
            plainprops.append((String)property.getKey()).append("=").append(((ConfigValue)property.getValue()).unwrapped().toString()).append(sep);
        }
        if (plainprops.length() > 0) {
            plainprops.setLength(plainprops.length() - sep.length());
        }
        return plainprops.toString();
    }

    protected void sbool(String path, Config config, String name, Consumer<Boolean> setter) {
        if (config.hasPath(name)) {
            boolean value = config.getBoolean(name);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void slong(String path, Config config, String name, Consumer<Long> setter) {
        if (config.hasPath(name)) {
            long value = config.getLong(name);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void sint(String path, Config config, String name, Consumer<Integer> setter) {
        if (config.hasPath(name)) {
            int value = config.getInt(name);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void siseconds(String path, Config config, String name, Consumer<Integer> setter) {
        if (config.hasPath(name)) {
            int value = (int)config.getDuration(name, TimeUnit.SECONDS);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void sseconds(String path, Config config, String name, Consumer<Long> setter) {
        if (config.hasPath(name)) {
            long value = config.getDuration(name, TimeUnit.SECONDS);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void sms(String path, Config config, String name, Consumer<Long> setter) {
        if (config.hasPath(name)) {
            long value = config.getDuration(name, TimeUnit.MILLISECONDS);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void sbytes(String path, Config config, String name, Consumer<Long> setter) {
        if (config.hasPath(name)) {
            long value = config.getBytes(name);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void sstr(String path, Config config, String name, Consumer<String> setter) {
        if (config.hasPath(name)) {
            String value = config.getString(name);
            this.log.debug("setting {}.{} = {}", new Object[]{path, name, value});
            setter.accept(value);
        }
    }

    protected void sconf(String path, Config config, String name, Consumer<Config> setter) {
        if (config.hasPath(name)) {
            Config value = config.getConfig(name);
            setter.accept(value);
        }
    }

    protected void each(Config conf, BiConsumer<String, Config> callback) {
        for (String name : this.names(conf)) {
            callback.accept(name, conf.getConfig(name));
        }
    }

    private Iterable<String> names(Config conf) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        conf.root().forEach((k, v) -> result.add((String)ConfigUtil.splitPath((String)k).get(0)));
        return result;
    }
}

