/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.eventbus;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.greenrobot.eventbus.EventBus;
import org.jooby.Env;
import org.jooby.Jooby;

public class EventBusby
implements Jooby.Module {
    private static final Function<Config, EventBus> DEFAULT = c -> EventBus.getDefault();
    private final Function<Config, EventBus> factory;
    private final List<Object> initialSubscribers = new ArrayList<Object>();

    public EventBusby(@Nonnull Function<Config, EventBus> factory) {
        this.factory = factory;
    }

    public EventBusby(@Nonnull Supplier<EventBus> factory) {
        this((Config c) -> (EventBus)factory.get());
    }

    public EventBusby() {
        this(DEFAULT);
    }

    public EventBusby register(@Nonnull Object subscriber) {
        this.initialSubscribers.add(subscriber);
        return this;
    }

    public EventBusby register(@Nonnull Class subscriber) {
        this.initialSubscribers.add(subscriber);
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        EventBus eventbus = this.factory.apply(conf);
        binder.bind(EventBus.class).toInstance((Object)eventbus);
        ArrayList subscribers = new ArrayList(this.initialSubscribers.size());
        env.onStart(registry -> {
            this.initialSubscribers.forEach(candidate -> {
                Object subscriber = candidate;
                if (subscriber instanceof Class) {
                    subscriber = registry.require((Class)subscriber);
                }
                subscribers.add(subscriber);
                eventbus.register(subscriber);
            });
            this.initialSubscribers.clear();
        });
        env.onStop(() -> subscribers.forEach(arg_0 -> ((EventBus)eventbus).unregister(arg_0)));
    }
}

