/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.flyway;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.inject.Provider;
import org.flywaydb.core.Flyway;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.internal.flyway.FlywayManaged;

public class Flywaydb
implements Jooby.Module {
    private String name;

    public Flywaydb(String name) {
        this.name = Objects.requireNonNull(name, "Flyway name is required.");
    }

    public Flywaydb() {
        this("flyway");
    }

    public void configure(Env env, Config config, Binder binder) {
        Config $flyway = config.getConfig(this.name).withFallback((ConfigMergeable)config.getConfig("flyway"));
        if ($flyway.hasPath("url")) {
            binder.bind(Flyway.class).toProvider((Provider)new FlywayManaged($flyway)).asEagerSingleton();
        } else {
            binder.bind(Key.get(Config.class, (Annotation)Names.named((String)"flyway.conf"))).toInstance((Object)$flyway);
            binder.bind(Flyway.class).toProvider(FlywayManaged.class).asEagerSingleton();
        }
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"flyway.conf");
    }
}

