/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.flyway;

import com.google.inject.name.Named;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jooby.Managed;

public class FlywayManaged
implements Provider<Flyway>,
Managed {
    private Flyway flyway = new Flyway();
    private Iterable<Command> commands;

    @Inject
    public FlywayManaged(DataSource ds, @Named(value="flyway.conf") Config config) {
        this.flyway.configure(this.props(config));
        this.flyway.setDataSource(ds);
        this.commands = this.commands(config);
    }

    private Iterable<Command> commands(Config config) {
        Object value = config.getAnyRef("run");
        ArrayList<String> commands = new ArrayList<String>();
        if (value instanceof List) {
            commands.addAll((List)value);
        } else {
            commands.add(value.toString());
        }
        return commands.stream().map(command -> Command.valueOf(command.toLowerCase())).collect(Collectors.toList());
    }

    public FlywayManaged(Config config) {
        this.flyway.configure(this.props(config));
        this.commands = this.commands(config);
    }

    public void start() throws Exception {
        this.commands.forEach(cmd -> cmd.run(this.flyway));
    }

    public void stop() throws Exception {
    }

    public Flyway get() {
        return this.flyway;
    }

    private Properties props(Config config) {
        Properties props = new Properties();
        config.withoutPath("run").entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            if (value instanceof List) {
                value = ((List)value).stream().collect(Collectors.joining(","));
            }
            props.setProperty("flyway." + (String)prop.getKey(), value.toString());
        });
        return props;
    }

    private static enum Command {
        migrate{

            @Override
            public void run(Flyway flyway) {
                flyway.migrate();
            }
        }
        ,
        clean{

            @Override
            public void run(Flyway flyway) {
                flyway.clean();
            }
        }
        ,
        info{

            @Override
            public void run(Flyway flyway) {
                flyway.info();
            }
        }
        ,
        validate{

            @Override
            public void run(Flyway flyway) {
                flyway.validate();
            }
        }
        ,
        baseline{

            @Override
            public void run(Flyway flyway) {
                flyway.baseline();
            }
        }
        ,
        repair{

            @Override
            public void run(Flyway flyway) {
                flyway.repair();
            }
        };


        public abstract void run(Flyway var1);
    }
}

