/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.flyway;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.flywaydb.core.Flyway;
import org.jooby.Env;
import org.jooby.Jooby;

public class Flywaydb
implements Jooby.Module {
    private String name;

    public Flywaydb(String name) {
        this.name = Objects.requireNonNull(name, "Flyway name is required.");
    }

    public Flywaydb() {
        this("flyway");
    }

    public void configure(Env env, Config config, Binder binder) {
        Config $flyway = config.getConfig(this.name).withFallback((ConfigMergeable)config.getConfig("flyway"));
        Flyway flyway = new Flyway();
        flyway.configure(this.props($flyway));
        this.commands($flyway).forEach(cmd -> cmd.run(flyway));
        binder.bind(Flyway.class).toInstance((Object)flyway);
    }

    private Properties props(Config config) {
        Properties props = new Properties();
        config.withoutPath("run").entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            if (value instanceof List) {
                value = ((List)value).stream().collect(Collectors.joining(","));
            }
            props.setProperty("flyway." + (String)prop.getKey(), value.toString());
        });
        return props;
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"flyway.conf");
    }

    private Iterable<Command> commands(Config config) {
        Object value = config.getAnyRef("run");
        ArrayList<String> commands = new ArrayList<String>();
        if (value instanceof List) {
            commands.addAll((List)value);
        } else {
            commands.add(value.toString());
        }
        return commands.stream().map(command -> Command.valueOf(command.toLowerCase())).collect(Collectors.toList());
    }

    private static enum Command {
        migrate{

            @Override
            public void run(Flyway flyway) {
                flyway.migrate();
            }
        }
        ,
        clean{

            @Override
            public void run(Flyway flyway) {
                flyway.clean();
            }
        }
        ,
        info{

            @Override
            public void run(Flyway flyway) {
                flyway.info();
            }
        }
        ,
        validate{

            @Override
            public void run(Flyway flyway) {
                flyway.validate();
            }
        }
        ,
        baseline{

            @Override
            public void run(Flyway flyway) {
                flyway.baseline();
            }
        }
        ,
        repair{

            @Override
            public void run(Flyway flyway) {
                flyway.repair();
            }
        };


        public abstract void run(Flyway var1);
    }
}

