/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.flyway;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.funzy.Try;

public class Flywaydb
implements Jooby.Module {
    private String name;

    public Flywaydb(String name) {
        this.name = Objects.requireNonNull(name, "Flyway name is required.");
    }

    public Flywaydb() {
        this("db");
    }

    public void configure(Env env, Config conf, Binder binder) {
        Config $base = conf.getConfig("flyway");
        Config $flyway = (Config)Try.apply(() -> conf.getConfig(this.name).withFallback((ConfigMergeable)$base)).orElse((Object)$base);
        Flyway flyway = new Flyway();
        flyway.configure(Flywaydb.props($flyway));
        if (!$flyway.hasPath("url")) {
            Key dskey = Key.get(DataSource.class, (Annotation)Names.named((String)this.name));
            DataSource dataSource = (DataSource)env.get(dskey).orElseThrow(() -> new NoSuchElementException("DataSource missing: " + dskey));
            flyway.setDataSource(dataSource);
        }
        env.serviceKey().generate(Flyway.class, this.name, key -> binder.bind(key).toInstance((Object)flyway));
        Iterable<Command> cmds = Flywaydb.commands($flyway);
        env.onStart(registry -> cmds.forEach(cmd -> cmd.run(flyway)));
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"flyway.conf");
    }

    private static Properties props(Config config) {
        Properties props = new Properties();
        config.withoutPath("run").entrySet().forEach(prop -> {
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            if (value instanceof List) {
                value = ((List)value).stream().collect(Collectors.joining(","));
            }
            props.setProperty("flyway." + (String)prop.getKey(), value.toString());
        });
        return props;
    }

    private static Iterable<Command> commands(Config config) {
        Object value = config.getAnyRef("run");
        ArrayList<String> commands = new ArrayList<String>();
        if (value instanceof List) {
            commands.addAll((List)value);
        } else {
            commands.add(value.toString());
        }
        return commands.stream().map(command -> Command.valueOf(command.toLowerCase())).collect(Collectors.toList());
    }

    private static enum Command {
        migrate{

            @Override
            public void run(Flyway flyway) {
                flyway.migrate();
            }
        }
        ,
        clean{

            @Override
            public void run(Flyway flyway) {
                flyway.clean();
            }
        }
        ,
        info{

            @Override
            public void run(Flyway flyway) {
                flyway.info();
            }
        }
        ,
        validate{

            @Override
            public void run(Flyway flyway) {
                flyway.validate();
            }
        }
        ,
        baseline{

            @Override
            public void run(Flyway flyway) {
                flyway.baseline();
            }
        }
        ,
        repair{

            @Override
            public void run(Flyway flyway) {
                flyway.repair();
            }
        };


        public abstract void run(Flyway var1);
    }
}

