/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.flyway;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.funzy.Try;

public class Flywaydb
implements Jooby.Module {
    private String name;

    public Flywaydb(String name) {
        this.name = Objects.requireNonNull(name, "Flyway name is required.");
    }

    public Flywaydb() {
        this("db");
    }

    public void configure(Env env, Config conf, Binder binder) {
        Config $base = this.flyway(conf.getConfig("flyway"));
        Config $flyway = (Config)Try.apply(() -> conf.getConfig(this.name).withFallback((ConfigMergeable)$base)).orElse((Object)$base);
        Flyway flyway = new Flyway();
        Properties props = Flywaydb.props($flyway);
        flyway.configure(props);
        if (!props.containsKey("flyway.url")) {
            Key dskey = Key.get(DataSource.class, (Annotation)Names.named((String)this.name));
            DataSource dataSource = (DataSource)env.get(dskey).orElseThrow(() -> new NoSuchElementException("DataSource missing: " + dskey));
            flyway.setDataSource(dataSource);
        }
        env.serviceKey().generate(Flyway.class, this.name, key -> binder.bind(key).toInstance((Object)flyway));
        Iterable<Command> cmds = Flywaydb.commands($flyway);
        cmds.forEach(cmd -> cmd.run(flyway));
    }

    private Config flyway(Config conf) {
        Config flyway = conf.root().entrySet().stream().filter(it -> ((ConfigValue)it.getValue()).valueType() != ConfigValueType.OBJECT).reduce(ConfigFactory.empty(), (seed, entry) -> seed.withValue((String)entry.getKey(), (ConfigValue)entry.getValue()), Config::withFallback);
        return flyway;
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"flyway.conf");
    }

    private static Properties props(Config config) {
        Properties props = new Properties();
        config.withoutPath("run").entrySet().forEach(prop -> {
            String propertyName;
            Object value = ((ConfigValue)prop.getValue()).unwrapped();
            if (value instanceof List) {
                value = ((List)value).stream().collect(Collectors.joining(","));
            }
            if (Flywaydb.isFlywayProperty(propertyName = (String)prop.getKey())) {
                props.setProperty("flyway." + (String)prop.getKey(), value.toString());
            }
        });
        return props;
    }

    static boolean isFlywayProperty(String name) {
        String setter = "set" + name;
        return Stream.of(Flyway.class.getMethods()).filter(m -> m.getName().equalsIgnoreCase(setter)).findFirst().map(m -> true).orElseGet(() -> ImmutableSet.of((Object)"driver", (Object)"url", (Object)"user", (Object)"password").contains((Object)name));
    }

    private static Iterable<Command> commands(Config config) {
        Object value = config.getAnyRef("run");
        ArrayList commands = new ArrayList();
        if (value instanceof List) {
            commands.addAll((List)value);
        } else {
            Stream.of(value.toString().split(",")).map(String::trim).forEach(commands::add);
        }
        return commands.stream().map(command -> Command.valueOf(command.toLowerCase())).collect(Collectors.toList());
    }

    private static enum Command {
        migrate{

            @Override
            public void run(Flyway flyway) {
                flyway.migrate();
            }
        }
        ,
        clean{

            @Override
            public void run(Flyway flyway) {
                flyway.clean();
            }
        }
        ,
        info{

            @Override
            public void run(Flyway flyway) {
                flyway.info();
            }
        }
        ,
        validate{

            @Override
            public void run(Flyway flyway) {
                flyway.validate();
            }
        }
        ,
        baseline{

            @Override
            public void run(Flyway flyway) {
                flyway.baseline();
            }
        }
        ,
        repair{

            @Override
            public void run(Flyway flyway) {
                flyway.repair();
            }
        };


        public abstract void run(Flyway var1);
    }
}

