/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Parser;
import org.jooby.Renderer;
import org.jooby.json.GsonParser;
import org.jooby.json.GsonRenderer;

public class Gzon
implements Jooby.Module {
    private MediaType type;
    private BiConsumer<GsonBuilder, Config> configurer;

    public Gzon(MediaType type) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
    }

    public Gzon() {
        this(MediaType.json);
    }

    public Gzon doWith(BiConsumer<GsonBuilder, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this;
    }

    public Gzon doWith(Consumer<GsonBuilder> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        this.configurer = (gson, conf) -> configurer.accept((GsonBuilder)gson);
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        GsonBuilder gsonb = new GsonBuilder();
        if (this.configurer != null) {
            this.configurer.accept(gsonb, config);
        }
        Gson gson = gsonb.create();
        binder.bind(Gson.class).toInstance((Object)gson);
        Multibinder.newSetBinder((Binder)binder, Parser.class).addBinding().toInstance((Object)new GsonParser(this.type, gson));
        Multibinder.newSetBinder((Binder)binder, Renderer.class).addBinding().toInstance((Object)new GsonRenderer(this.type, gson));
    }
}

