/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.google.gson.Gson;
import java.util.Objects;
import org.jooby.MediaType;
import org.jooby.Renderer;

class GsonRenderer
implements Renderer {
    private MediaType type;
    private Gson gson;

    public GsonRenderer(MediaType type, Gson gson) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
        this.gson = Objects.requireNonNull(gson, "Gson is required.");
    }

    public void render(Object object, Renderer.Context ctx) throws Exception {
        if (ctx.accepts(this.type)) {
            ctx.type(this.type).send(this.gson.toJson(object));
        }
    }

    public String name() {
        return "json";
    }

    public String toString() {
        return this.name();
    }
}

