/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.google.gson.Gson;
import com.google.inject.TypeLiteral;
import java.util.Objects;
import org.jooby.MediaType;
import org.jooby.Parser;

class GsonParser
implements Parser {
    private final MediaType type;
    private final Gson gson;

    public GsonParser(MediaType type, Gson gson) {
        this.type = Objects.requireNonNull(type, "Media type is required.");
        this.gson = Objects.requireNonNull(gson, "Gson is required.");
    }

    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
        MediaType ctype = ctx.type();
        if (ctype.isAny()) {
            return ctx.next();
        }
        if (ctype.matches(this.type)) {
            return ctx.ifbody(body -> this.gson.fromJson(body.text(), type.getType())).ifparam(values -> this.gson.fromJson((String)values.first(), type.getType()));
        }
        return ctx.next();
    }

    public String toString() {
        return "gson";
    }
}

