/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbs;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.GuavaTemplateCache;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jooby.Body;
import org.jooby.Jooby;
import org.jooby.Mode;
import org.jooby.View;

public class Hbs
implements HelperRegistry,
Jooby.Module {
    private static final TemplateCache NOOP = NullTemplateCache.INSTANCE;
    private final Handlebars hbs;

    public Hbs(Handlebars handlebars) {
        this.hbs = Objects.requireNonNull(handlebars, "A handlebars instance is required.");
    }

    public Hbs() {
        this(new Handlebars((TemplateLoader)new ClassPathTemplateLoader("/", ".html")));
    }

    public void configure(Mode mode, Config config, Binder binder) throws Exception {
        TemplateCache cache = mode.ifMode("dev", () -> NOOP).orElseGet(() -> new GuavaTemplateCache(CacheBuilder.from((String)config.getString("hbs.cache")).build()));
        this.hbs.with(cache);
        binder.bind(Handlebars.class).toInstance((Object)this.hbs);
        Multibinder.newSetBinder((Binder)binder, Body.Formatter.class).addBinding().toInstance((Object)new Engine(this.hbs));
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"hbs.conf");
    }

    public <C> Helper<C> helper(String name) {
        return this.hbs.helper(name);
    }

    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.hbs.helpers();
    }

    public <H> Hbs registerHelper(String name, Helper<H> helper) {
        this.hbs.registerHelper(name, helper);
        return this;
    }

    public <H> HelperRegistry registerHelperMissing(Helper<H> helper) {
        this.hbs.registerHelperMissing(helper);
        return this;
    }

    public HelperRegistry registerHelpers(Object helperSource) {
        this.hbs.registerHelpers(helperSource);
        return this;
    }

    public HelperRegistry registerHelpers(Class<?> helperSource) {
        this.hbs.registerHelpers(helperSource);
        return this;
    }

    public HelperRegistry registerHelpers(URI location) throws Exception {
        this.hbs.registerHelpers(location);
        return this;
    }

    public HelperRegistry registerHelpers(File input) throws Exception {
        this.hbs.registerHelpers(input);
        return this;
    }

    public HelperRegistry registerHelpers(String filename, Reader source) throws Exception {
        this.hbs.registerHelpers(filename, source);
        return this;
    }

    public HelperRegistry registerHelpers(String filename, InputStream source) throws Exception {
        this.hbs.registerHelpers(filename, source);
        return this;
    }

    public HelperRegistry registerHelpers(String filename, String source) throws Exception {
        this.hbs.registerHelpers(filename, source);
        return this;
    }

    private static class Engine
    implements View.Engine {
        private Handlebars handlebars;

        public Engine(Handlebars handlebars) {
            this.handlebars = Objects.requireNonNull(handlebars, "A handlebars instance required.");
        }

        public String name() {
            return "hbs";
        }

        public void render(View view, Body.Writer writer) throws Exception {
            Template template = this.handlebars.compile(view.name());
            Object model = view.model();
            Context context = model instanceof Context ? (Context)model : Context.newBuilder((Object)model).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, MethodValueResolver.INSTANCE}).build();
            writer.text(out -> template.apply(context, out));
        }

        public String toString() {
            return this.name();
        }
    }
}

